% calc_dena
%
% This routine calculates a mean density anomaly from a mean TS profile.

tsmeanfile = '/data2/AOSN2/OAG/2003/Aug22/PJH02/ts_mean.dat';
gridsfile  = '/data/projects2/AOSN2/Grids/MBay/grids_MBay_cnd06.nc';
rhomeanfile = 'mean_den.dat';

%-------------------------------------------------------------------------------
% Read mean TS profile.
%-------------------------------------------------------------------------------

[z,t,s,status] = read_tsm (tsmeanfile);

if (status~=0)
   disp (' ');
   disp ('***Error:  CALC_DENA - unable to read mean TS file:');
   disp (['           ',setstr(34),tsmeanfile,setstr(34)]);
   disp (' ');
   return;
end;

clear status tsmeanfile

%-------------------------------------------------------------------------------
% Get central latitude.
%-------------------------------------------------------------------------------

[domdat,bath,landt,mcseg,mpseg,misle] = read_mask (gridsfile);

clear bath landt mcseg mpseg misle gridsfile;

coord = domdat(1);
lonc  = domdat(2);
latc  = domdat(3);
theta = domdat(4);
nx    = domdat(5);
ny    = domdat(6);
dx    = domdat(7);
dy    = domdat(8);
delx  = domdat(9);
dely  = domdat(10);

clear domdat;

[cenlon,cenlat] = xy2ll ((nx+1)/2,(ny+1)/2,coord,nx,ny,dx,dy,lonc,latc, ...
                         delx,dely,theta);

clear cenlon coord nx ny dx dy lonc latc delx dely theta

%-------------------------------------------------------------------------------
% While we're here, record a central coriolis parameter.
%-------------------------------------------------------------------------------

omega = 2*pi*366.25/(24*3600*365.25);
f0    = 2*omega*sin(cenlat*pi/180);

disp (' ');
disp (['At a latitude of ',num2str(cenlat),', f=',num2str(f0,9)]);
disp (' ');

clear f0 omega;

%-------------------------------------------------------------------------------
% Convert depth to pressure.
%-------------------------------------------------------------------------------

press = sw_pres (z',cenlat)';

clear cenlat;

%-------------------------------------------------------------------------------
% Compute mean density anomaly profile.
%-------------------------------------------------------------------------------

dena = sw_dens (s,t,press) - 1000;

clear press s t;

plot (dena,z);
set(gca,'YDir','Reverse');
xlabel ('Density Anomaly  (kg/m^3)');
ylabel ('Depth  (m)');

%-------------------------------------------------------------------------------
% Save mean density anomaly profile.
%-------------------------------------------------------------------------------

densi = [z', dena'];

clear dena z

eval (['save -ascii ',rhomeanfile,'  densi;']);

clear densi rhomeanfile
