function [z,t,s,status] = read_tsm (file);
%
% function [z,t,s,status] = read_tsm (file);
%
% This function reads the mean t-s profile
% in a format expected by the HOPS system.
%
% Input:
%
%    file.....The name of the output file.
%
% Output:
%
%    z........The profile depths.  (m)
%    t........The temperature.  (Celsius)
%    s........The salinity.  (PSU)
%    status...Flag indicating whether an error has
%             occured.
%             status = 0      ->  no error
%             status nonzero  ->  error

%-------------------------------------------------------------------------------
% Calls:  num_read
%-------------------------------------------------------------------------------

%-------------------------------------------------------------------------------
% Open file.
%-------------------------------------------------------------------------------

[fid,message] = fopen (file,'r');
if (fid==-1),
   disp([setstr(7),'***Error:  READ_TSM - unable to open file:',setstr(7)]);
   disp([setstr(7),'           ',setstr(34),file,setstr(34),setstr(7)]);
   disp([setstr(7),'           ',message,setstr(7)]);
   status = -1;
   return;
end;

%-------------------------------------------------------------------------------
% Read number of profile points..
%-------------------------------------------------------------------------------

np = num_read (fid);

%-------------------------------------------------------------------------------
% Read the profile.
%-------------------------------------------------------------------------------

[mat,count]=fscanf(fid,'%f',[3,np]);
[message,status] = ferror (fid);
if (status ~= 0),
   disp([setstr(7),'***Error:  READ_TSM - unable to read profile', ...
                                                     ' in  file:',setstr(7)]);
   disp([setstr(7),'           ',setstr(34),file,setstr(34),setstr(7)]);
   disp([setstr(7),'           ',message,setstr(7)]);
   disp([setstr(7),'           error flag = ',num2str(status),setstr(7)]);
   return;
end;
z=mat(1,:);
t=mat(2,:);
s=mat(3,:);

%-------------------------------------------------------------------------------
% Close the file.
%-------------------------------------------------------------------------------

status = fclose (fid);
if (status ~= 0),
   disp([setstr(7),'***Error:  READ_TSM - unable to close file:', ...
                                                                 setstr(7)]);
   disp([setstr(7),'           ',setstr(34),file,setstr(34),setstr(7)]);
   return;
end;
