function bar_move(h, axis_h, aspectR)
%
% bar_move(h, axis_h, aspectR)
%
% To arrange the colorbar so that it is attached to the main
% plot tightly. 
%
% On input, 
%        H:        is the handle returned by "colorbar"
%        AXIS_H:   is the GCA of the main contour plot.
%	 aspectR:  is the aspect ratio of the main plot. 
%		      it can be used to adjust the distance between
%		      the colorbar and main plot. The smaller, the
%		      farther away. Usually it is set 1.
%
% See also colorbar_arrange.m

% Relocate the colorbar so that it appends tightly to the picture.
% The entries of Position are repectively
%       [left pos,   top pos,   width,   height]
% of the box. The values are scaled.
 
  axPosition = get(axis_h, 'Position');
  cbarPosition = get(h, 'Position');
 
  axW = axPosition(3);
  extraSp = (axW - axW / aspectR) / 2.0;        % Extra space left on
                                        % the r.h.s due to the rescaling
                                        % based on the aspect ratio.
 
  cbarPosition(1) = axPosition(1) + axW - extraSp  + 0.01;
                                % The left side of cbar
                                % is apart from the right
                                % side of the box by 0.01.
 
  set(h, 'Position', cbarPosition);

