  function cont_plt(fld, s1, s2, ncl, aspectR, XTic, YTic, xyfill, mask) 
% 
% fld: the field to be plotted
% ncl: number of contour lines or vector of contour levels.
% aspectR: Aspect Ratio for the plots (1 : aspectR  is vert. to horiz.)
% XTic: X Tick, label or not ('y' or 'n')
% YTic: Y Tick, label or not ('y' or 'n')
% dayname: name of forecast day
% lev: Level no.
% scl: 0 (large-scale), 1 (meso-scale), or 2 (sub-mesoscale)
%
% Draw the contour plots with nice colorbar tics and location.
% The aspect ration is set such that the plots generated fit
% nicely in a rescaled latex inclusion.
%
% format short e;		% All the numbers are formatted like this.



fillcolor = [0.25 0.0 0.0];             % brown


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fmin = min(fld(:));  fmax = max(fld(:));
    fmid = 0.5 * (fmin + fmax);
% v = linspace(fmin, fmax, ncl);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


if (length(ncl)>1)
   colormap(jet(length(ncl)));
   [Cout, H, CF] = contourf (s1, s2, fld, ncl, 'w-');
   caxis(extrem(ncl));
   hcb = colorbarclvl (Cout,H,ncl);
   if xyfill(1,1) ~= 9999,
      hold on
        fill(xyfill(:,1), xyfill(:,2), fillcolor);
      hold off
   end
elseif mask <= (fmax - fmin),
   [cout, h, hcb] = contourf_bar(s1, s2, fld, ncl, 'w-');
   if xyfill(1,1) ~= 9999,
      hold on
        fill(xyfill(:,1), xyfill(:,2), fillcolor);
      hold off
   end
else
   fld = fmid * ones(size(fld));
   pcolor(s1, s2, fld)
   shading flat
   hcb = colorbar('vert');
   bartick = [fmid-mask : mask : fmid+mask];
   set(hcb, 'YTick', bartick);
   set(hcb, 'YTickLabel', bartick');
		fmin2 = truncate2(fmin, -2);
		fmax2 = truncate2(fmax, -2);

   if xyfill(1,1) ~= 9999, 
      hold on 
        fill(xyfill(:,1), xyfill(:,2), fillcolor); 
      hold off 
   end  

   text(median(s1)*0.4, median(s2)*1.15, [num2str(fmin2),' -'], ...
		'fontsize', 7, 'Color', 'k');
   text(median(s1)*0.4, median(s2)*0.85, [num2str(fmax2)],...
		'fontsize', 7, 'Color', 'k');
end


set(gca, 'Box', 'on');


set(gca, 'DataAspectRatio', [1 aspectR 1]);

if XTic == 'n',
   set(gca, 'XTickLabel', []);             % Do not label the x_tick
end
if YTic == 'n',
   set(gca, 'YTickLabel', []);             % Do not label the y_tick
end

set(gca, 'FontSize', 7);


set(hcb, 'FontSize', 7);
bar_move(hcb, gca, 1.15);
