
  function [cout, h, hcb] = contourf_bar(x, y, z, ncl, cnt_clt)
%
% [cout, h, hcb] = contourf_bar(x, y, z, ncl, cnt_clt)
%
% An implemented contourf + colorbarf.
%
% On input:
%    (x,y): coord
%    z:     state variable
%    cnt_clt: color and line type of the contour lines (e.g., 'w--')
%    ncl:   number of contour lines. This is for reference only,as
%           the output plot doesn't need to have exactly NCL lines.
% 
%
% On return:
%    [cout, h]: the returns same as contourf
%    hcb:       handle of the colobarf
% 
% Also see: colorbar_arrange

	zmax = max(z(:));
	zmin = min(z(:));

	zabs = max(abs(zmax), abs(zmin));


	b = log10(zabs);
	c1 = floor(b);
	c2 = b - c1; 

	z = z / 10^c1;

	zmax = max(z(:));
	zmin = min(z(:));

%%%%%  z is now rescaled onto the range (-10, 10).  %%%%%

	attach = '';
	if c1 ~= 0, attach = ['e', num2str(c1)]; end
        [one, m_att] = size(attach);
%
% scale indicator attached to the colorbar
%


	F = 1;		% contour resolution factor.

	v = linspace(zmin, zmax, ncl);
	v = nice(v, F);
	[one, ncl2] = size(v);		% ncl redefined here.


	for nloop = 1:5,
	   if ncl2 <= (ncl * 0.70),  
    	      F = 2*nloop;
	      v = nice(v, F);
	      [one, ncl2] = size(v);
	   else
	      break;
	   end
	end
	


	[cout, h] = contourf(x, y, z, v, cnt_clt);
	hcb = colorbarf(cout, h);


	yticklab = v';
	  if v(ncl2) ~= zmax, 
	     yticklab(ncl2) = truncate(zmax, -2);
	  end
	yticklab(ncl2+1) = 0.;

	yticklab = truncate(yticklab, -2);	% truncate to 2nd frac digit.

	yticklab = num2str(yticklab);

		
	[one, wtick] = size(yticklab);

	intv = round(ncl2/5.0);		% label the colorbar every intv boxes.

        for m = 1 : wtick,
	    for k = 1 : ncl2+1,
	        tmptick(k, m:m) = ' ';
	    end
	    for k = 2 : intv : ncl2+1,   
	        tmptick(k, m:m) = yticklab(k, m:m);
	    end
	end

	yticklab = tmptick;

	powerlab = [yticklab(2,:), attach];

		for m = wtick+1 : wtick+m_att,
		for k = 1 : ncl2+1,
		yticklab(k, m : m) = ' ';
		end
	 	end

	yticklab(2, :) = powerlab;

	for m = 1 : wtick, 
	yticklab(1, m:m) = ' ';
	end


	set(hcb, 'YTickLabel', yticklab);
	

	set(hcb, 'Color', [0 0 0.3]);
%
%   set the color for the limit contour line
%   this is useful whenever unexpected white box appears.
%
	

