  function [xyfill] = find_fill(kp, z_lev, H)
% Find the boundary for filling
%
%	xyfill:  an nx2 matrix, corresponding to the
%		 coord pairs for the boundary.
%
   	[jm,im] = size(H);
	tmp = ones(jm, im);
	tmp = tmp * (-100);

	hit_bot = 'n';
	xyfill = [9999, 9999];
	
	for j = 1 : jm,
	for i = 1 : im,
	    if z_lev(kp) > H(j,i),
		tmp(j, i) = 0;
		hit_bot = 'y';
	    end
	end
	end

if hit_bot == 'y',

  [cout, h, cf] = contourf(tmp, [-100, 0]);

  cf = cf';
% cf(1,1) =  -100;  
  n1 = cf(1,2);
  n2 = cf(n1+2, 2);

  xyfill = zeros(n2, 2);
  xyfill(:, :) = cf(n1+2 : n1+n2+1, :);

end
