function scalar

warning off

grdfile = '/data/projects2/AOSN2/Grids/MBay/grids_MBay_cnd05n.nc';
work_dir = 'work2';
zlev_path = '/data2/AOSN2/san/MS-EVA/profile';


nid = netcdf(grdfile);
landt(:,:) = nid{'landt'}(:,:);
depth(:,:) = nid{'tbath'}(:,:);
close(nid)

depth = abs(depth);
depth(find(landt==0)) = -999;


for day = 1:32,
    offset = 5;
    calendar_day = ['AUG ', num2str(day + offset)];
    if (day+offset > 31),  calendar_day = ['SEP ', num2str(day+offset-31)]; end

for lev = [2, 6, 12, 20],
figure(1)
clf
     xyfill = get_fill (grdfile, zlev_path, lev);

subplot(2,3,1)
    scalar_plt('temp', -1, day, calendar_day, lev, depth, work_dir, xyfill)
subplot(2,3,2)
    scalar_plt('temp', 0, day, calendar_day, lev, depth, work_dir, xyfill)
    set(gca, 'YTickLabel', '');
subplot(2,3,3)
    scalar_plt('temp', 1, day, calendar_day, lev, depth, work_dir, xyfill)
    set(gca, 'YTickLabel', '');
print(gcf, '-depsc', ...
       		    ['../plots/', work_dir, '/temp/day', num2str(day), ...
     		     '_lev', num2str(lev), '.eps']);

% print(gcf, '-djpeg', ...
%    		    ['../plots/', work_dir, '/temp/day', num2str(day),...
%		     '_lev', num2str(lev), '.jpg']);

end
end



function xyfill = get_fill (grdname, zlev_path, kp)

nid = netcdf(grdname);
   H(:,:) = nid{'tbath'}(:,:);
   landt(:,:) = nid{'landt'}(:,:);
close(nid)

    H = abs(H);
    H(find(landt<=0)) = -100;

file_zlev = [zlev_path, '/drho_dz.dat'];
zz = load(file_zlev);
z_lev = zz(:,1);
z_lev = abs(z_lev);

xyfill = find_fill(kp, z_lev, H);


%%%%%%%%%%%%% Find the boundary for filling %%%%%%%%%%%%
  function [xyfill] = find_fill(kp, z_lev, H)
%
%       xyfill:  an nx2 matrix, corresponding to the
%                coord pairs for the boundary.
%
        [jm,im] = size(H);
        tmp = ones(jm, im);
        tmp = tmp * (-100);

        hit_bot = 'n';
        xyfill = [9999, 9999];

        for j = 1 : jm,
        for i = 1 : im,
            if z_lev(kp) > H(j,i),
                tmp(j, i) = 0;
                hit_bot = 'y';
            end
        end
        end

if hit_bot == 'y',

  [cout, h, cf] = contourf(tmp, [-100, 0]);

  cf = cf';
% cf(1,1) =  -100;
  n1 = cf(1,2);
  n2 = cf(n1+2, 2);

  xyfill = zeros(n2, 2);
  xyfill(:, :) = cf(n1+2 : n1+n2+1, :);

end




function scalar_plt(var, win, day, calendar_day, lev, depth, work_dir, xyfill)

levs = load ('../profile/stdlvls.dat');
DIR =  ['../', work_dir, '/Data-mwt/t', num2str(day)];

fillcolor = [0.25 0.0 0.0];             % brown



scl = '';
if win == 0, scl = '_bar'; end
if win == 1, scl = '_prime'; end
if win == 2, scl = '_dprime'; end

scalar = load([DIR, '/', var, scl, '_lev', num2str(lev), '.dat']);

[m,n] = size(scalar);

	wet_pts = find(depth > levs(lev));
 	dry_pts = find(depth <= levs(lev));
	landvalue = mean(scalar(wet_pts));

scalar(dry_pts) = landvalue;


[cout, h, hcb] = contourf_bar([1:n], [1:m], scalar, 15, 'w-');
   if xyfill(1,1) ~= 9999,
      hold on
        fill(xyfill(:,1), xyfill(:,2), fillcolor);
      hold off
   end



set(gca, 'Box', 'on')

if win >= 0,
   title([calendar_day, ',   WIN ', num2str(win)]);
      else
   title([calendar_day, ', ', num2str(levs(lev)), ' m']);
end
   

