% The following scripts compute the derivatives of rho_bar w.r.t z
% Specifically, properties
%
%	     s = - d rho / dz
%	dlogsz =   d (log s) / dz
%
% are computed and stored in data file 
%
%	drho_dz.dat
%
% If these profiles are to be computed in Fortran,
% double precision has to be used because of the huge
% part of rho_bar which will be removed during the computation.
%

clear

denhome = '/data2/AOSN2/PE/2005/May31/PJH02/MSEVA/pressure/mean_file/';

z              = load ([denhome,'stdlvls.dat']);
mean_den_profl = load ([denhome,'mean_den_profl.dat']);

clear denhome;

dena_mean_ref = mean_den_profl(:,2);
zref = mean_den_profl(:,1);
[kmax, one] = size(zref);

km = length(z);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s = - d rho / dz   for all reference z-level.
%
  for k = 1 : kmax,
      km1 = k-1;		if km1<1, km1=1; end
      kp1 = k+1;		if kp1>kmax, kp1=kmax; end
      sref(k,1) =  (dena_mean_ref(km1) - dena_mean_ref(kp1)) / 2.0;
      sref(k) = - sref(k);
  end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



for k = 1 : km,
%    k0 = floor(z(k));
    k0 = max(find(zref<=z(k)));
    k1 = min([(k0+1) kmax]);
    dena_mean(k,1) = dena_mean_ref(k0) + (dena_mean_ref(k1) - ...
		     dena_mean_ref(k0)) * (z(k) - k0);
%%    s(k,1) = sref(k0) + (sref(k1) - sref(k0)) * (z(k) - k0);
      % don't compute this way, or it would be very noisy.
end

    dz(1,1) = 2 * z(1);
    for k = 2 : km,
    dz(k,1) = (z(k) - z(k-1) - dz(k-1) * 0.5) * 2;
	if (dz(k,1) <= 0),
	   fprintf('Bad flat level setting maks dz=0.\n');
 	   break;
	end
    end

dz


s = zeros(km,1);
dlogsz = zeros(km,1);

        for k=1 : km
                km1 = k - 1;
                kp1 = k + 1;
                if (km1 < 1),  km1 = 1; end
                if (kp1 > km),  kp1 = km; end
           rhokm1 = dena_mean(km1);
           rhok = dena_mean(k);
           rhokp1 = dena_mean(kp1);

           dz1 = dz(km1) + dz(k);
           dz2 = dz(k) + dz(kp1);

        s(k) = (rhokm1 - rhok) / dz1 + (rhok - rhokp1) / dz2;
        s(k) = - s(k);

        dlogsz(k) = (rhokm1 - rhok) / dz1  - (rhok - rhokp1) / dz2;
        dlogsz(k) = dlogsz(k) / (dz1 + dz2);
        dlogsz(k) = dlogsz(k) * 8;
        dlogsz(k) = - dlogsz(k) / s(k);

        end


	Data = [z, dz, dena_mean, s, dlogsz];

	save -ascii drho_dz.dat Data


figure(1)
clf
    subplot(1,2,1)
     	plot(dena_mean_ref, zref)
	axis ij
	hold on
	plot(dena_mean, z, 'ro')
	hold off
%	axis tight
        axis([24 30 0 600]);
	set(gca, 'DataAspectRatio', [1 50 1])
	ylabel('Depth (m)')
	xlabel('\rho (DENA bar) (kg/m^3)')
	set(gca, 'XAxisLocation', 'top');
	set(gca, 'YAxisLocation', 'left');

    subplot(1,2,2)
	plot(s, z, 'r-o')
	hold on
	plot(dlogsz, z, 'g--*')
	hold off
	axis ij
	axis([-0.05 0.05 0 600])
        set(gca, 'DataAspectRatio', [1 3000 1])
        ylabel('Depth (m)')    
        xlabel('s=-d\rho/dz (solid) & d(logs)/dz (dashed)')
        set(gca, 'XAxisLocation', 'top');
        set(gca, 'YAxisLocation', 'left');
 

	print -deps mean_rho.eps


	



% This way to compute dlogsz yields slightly a different dlogsz
% compared to that when dlogsz is obtained directly from ds / dz,
% particularly on the edges (surface and bottom).
	
%	for k = 1:km,
%	    km1 = k-1;
%	    kp1 = k+1;
%               if (km1 < 1),  km1 = 1 ; end
%               if (kp1 > km),  kp1 = km; end
%           rhokm1 = s(km1);
%           rhok = s(k);
%           rhokp1 = s(kp1);
%
%           dz1 = dz(km1) + dz(k);
%           dz2 = dz(k) + dz(kp1);
%
%        ds(k) = (rhokm1 - rhok) / dz1 + (rhok - rhokp1) / dz2;
%        ds(k) = ds(k) / s(k);
%	end


