% profl
%                                                                    N
% Refines the mean density profile to 1m resolution in the range 0:(2  - 1)

rhomeanfile = 'mean_den.dat';
rhoreffile  = 'mean_den_profl.dat';
basezfile   = 'zref.dat';
baserhofile = 'rhoref.dat';

method = 'linear';

%-------------------------------------------------------------------------------
% Read mean density anomaly profile.
%-------------------------------------------------------------------------------

mean_den = load (rhomeanfile);

clear rhomeanfile;

z   = mean_den(:,1);
rho = mean_den(:,2);

clear mean_den;

%-------------------------------------------------------------------------------
% Construct refined depths.
%-------------------------------------------------------------------------------

pwrmax = fix(log(max(z(:))+1)/log(2));
zmax   = round(2^pwrmax) - 1;

zref = (0:zmax)';

clear pwrmax zmax;

%-------------------------------------------------------------------------------
% Refine density profile.
%-------------------------------------------------------------------------------

rhoref = interp1 (z,rho,zref,method);

clear z rho method

%-------------------------------------------------------------------------------
% Save refined density profile.
%-------------------------------------------------------------------------------

dum = [zref, rhoref];

eval (['save ',rhoreffile,' dum -ascii;']);

clear dum rhoreffile

eval (['save ',basezfile,' zref -ascii;']);

clear zref basezfile

eval (['save ',baserhofile,' rhoref -ascii;']);

clear rhoref baserhofile
