        subroutine band_pivot (ndim,maxband,a,b,logr,logrp,
     +			    ndim1,maxband1, lpivot)
c
c       This solver has been modified to solve a Poission equation
c       with Neumman boundary conditions. (u-boundary cond.)
c       The modification is at line     
c               b(ndim)=b(ndim)/a(ihba1,ndim)
c       which has been changed into
c               b(ndim) = 0.
c
c       After pivot-selecting process, the line with zero pivot
c       has been moved to the last line, so this makes sense for
c       a matrix A with only one zero eigenvalue.


c
c       This subroutine solves the banded equation set Ax = B with
c	pivoting. The band of matrix A could differ line by line.
c       The width is measured by an array LOGR (see below).
c
c
c       On entry:
c           NDIM:     number of equations of the set
c           MAXBAND:  maximal band width
c           A:        the matrix re-organized in a memory-saving mode.
c		      note A is in fact stored in format (maxband, ndim).
c		      (see below for an example.)
c		      On exit A is changed.
c           B:        vector on the r.h.s of the eq set
c		 	On exit B is changed.
c           LOGR:     logical ruller, measuring the half width of the
c                     band at each line of the upper diagonal of matrix A.
c		      (the diagonal pt is not counted in.)
c           LOGRP:    for temporal storage of logr only,
c                     no specification is needed.
c           NDIM1:    prescribed number of eqns 
c           MAXBAND1: prescribed maximal band width
c
c
c       Example of matrix storage:
c       originally, A is of NDIM by NDIM
c               A = [1 2 3 0 0 0 0
c                    0 1 2 0 0 0 0
c                    2 0 1 2 0 0 0
c                    0 0 1 0 2 3 0
c                    0 0 3 2 1 2 3
c                    0 0 0 2 0 1 2
c                    0 0 0 0 3 2 1]
c
c       where LOGR = (2 1 1 2 2 1 0)    NDIM = 7       MAXBAND = 5
c
c       the compressed form:  NDIM by MAXBAND
c               A~ = [1 2 3 0 0 0 0
c                     0 1 2 3 0 0 0
c                     2 0 1 2 0 0 0
c                     0 1 0 2 3 0 0
c                     3 2 1 2 3 0 0
c                     2 0 1 2 0 0 0
c                     3 2 1 0 0 0 0]
c	In this subroutine, A~ is stored as A^T to expedite computation.
c	[i.e., A(i,j) is actually A(j,i)]
c
c       On output:
c           B: 	      the solution vector
c	    LPIVOT:   a vector storing line number where pivot sits
c
c
c       Author:  X. San Liang
c
c	Version 1.0
c       Date:    December 12, 1992
c
c	Version 1.2
c	Date:	June 3, 2004
c
c
        integer ndim, maxband, ndim1, maxband1,minkn
        integer logr(ndim1),logrp(ndim1)
	integer lpivot(ndim1)
        double precision a(maxband1,ndim1),b(ndim1)
c
        integer ihb, ihba1, i, j, k, jj, kk,ki, kj, ndimm1, lpt
        integer kamend, iamend, ia1, ka1, logai, logak, klogr
c
        double precision pp, aikk, akkj
	double precision pivot, tmp
c
        ihb=(maxband-1)/2
        ihba1=ihb+1
        do 5 k=1,ndim
5       logrp(k)=logr(k)
 
        ndimm1=ndim-1
 
        do 30 k=1,ndimm1
        kamend=min0(-k+ihba1,0)
 
        kk=k+kamend

        minkn=min0(k+ihb,ndim)
        ka1=k+1
c
c ---------------- Pivoting ------------------
c
	lpivot(k) = k
	pivot = abs(a(kk,k))
	   
	do i = ka1, minkn
	   iamend = min0(-i+ihba1,0)
	   ki = k + iamend
	       if (abs(a(ki,i)) .gt. pivot) then
	          lpivot(k) = i
	          pivot = abs(a(ki,i))
	       endif
	enddo

	    lpt = lpivot(k)
	if (lpt .ne. k) then
	   logrp(k) = logrp(lpt) + lpt - k
c		kamend
		iamend = min0(-lpt+ihba1,0)
		klogr = k + logrp(k)
	   do j = k, klogr  
	      tmp = a(j+iamend,lpt)
	      a(j+iamend,lpt) = a(j+kamend, k)
	      a(j+kamend, k) = tmp
	   enddo
	      tmp = b(lpt) 
	      b(lpt) = b(k)
	      b(k) = tmp
	endif
c
c ---------------------------------------------
c

        pp=1./a(kk,k)
        logak=logrp(k)+k
 
        do 10 j=ka1,logak
          jj=j+kamend
10      a(jj,k)=a(jj,k)*pp
        b(k)=b(k)*pp
 
c          minkn=min0(k+ihb,ndim)
        do 30 i=ka1,minkn
        iamend=min0(-i+ihba1,0)
 
        kk=k+iamend
	aikk=a(kk,i)
        if(aikk.ne.0.)then
          do 20 j=ka1,logak
          jj=j+iamend
          kj=j+kamend
	  akkj=a(kj,k)
20        a(jj,i)=a(jj,i)-aikk*akkj
          logrp(i)=max((i+logrp(i)),(k+logrp(k)))-i
          b(i)=b(i)-aikk*b(k)
        end if
30      continue
 
c        b(ndim)=b(ndim)/a(ihba1,ndim)
	b(ndim)	= 0.			! for Neumman bdry cond only.
 
        do 40 i=ndimm1,1,-1
            logai=logrp(i)+i
            ia1=i+1
 
          iamend=min0(-i+ihba1,0)
        do 40 j=ia1,logai
          jj=j+iamend
40      b(i)=b(i)-a(jj,i)*b(j)
 
        return
        end
 

