
c	Standard inputs

	subroutine para_input
#include <config.h>
#include <wt_1d.h>
#include <input.h>

c       Read the horizontal level to be processed
        read(5,*) kp

c	Read the horizontal delimits for the domain to be analyzed.
        read(5,*) ix0, ix1, jy0, jy1


c	Read in the B. extension type for the transforms.
        read(5, *) ext_id

c	Read in grid stepsizes (in meters & seconds)
	read(5,*) dx, dy, dt

c	Read in file name for basic profile info
c       e.g., fname = '../profile/drho_dz.dat'
        read(5,'(a)') fname

        call col_finput(fname, dena_mean, 1, km, 3)
	call col_finput(fname, dz, 1, km, 2)
	call col_finput(fname, s, 1, km, 4)
	call col_finput(fname, dlogsz, 1, km, 5)

c	Read the path of input data (pre-processed data)
c	e.g., './Data-mwt'
	read(5,'(a)') evapath

c       Read the path of output ms-eva data
c	e.g., './Data-eva'
        read(5,'(a)') fname

	call surf_flux

	return
	end
	
		

c ------- To be implemented ...
c ------- depth_mix(i,j) should be a function of MLDOPT and surf. flux
c ------- smflux & sdflux are from the wind and heat data
c ------- fkph, fkpm, wvmix, wdmix are from pe.in, with units coverted
c
	subroutine surf_flux
#include <config.h>
#include <wt_1d.h>
#include <input.h>
	integer i, j
	real conv

	do j = 1, jm
	   do i = 1, im
	      smflux(i,j) = 0.0
	      sdflux(i,j) = 0.0
	   enddo
	enddo

	MLDOPT = 1
		conv = 1.e-4	! convert from cm^2/s to m^2/s
	fkph = 0.01 * conv
	fkpm = 0.1 * conv
	wvmix = 60.0 * conv
	wdmix = 12.0 * conv

	do j = 1, jm
	   do i = 1, im
	      depth_mix(i,j) = 15.0
	   enddo
	enddo

	return
	end
