
	subroutine fltxy (gflt, g, im, jm, maxscl, j0, fltpath)

c	Two-dimensional cubic spline low-pass filter 
c	       with quincunx dilation matrix
c	Currently only zero-padding extension is used.
c	(Check the zero-padding line below)
c	dx and dy must be the same 
c
c	On input:
c	   * maxscl:  largest scale to be handled (in No. of grid pts)
c	   * j0:      low-pass filter scale level relative to maxscl
c		      2^{j0/2} must be smaller than maxscl/4
c	   * g:	      function to be filtered
c	   * im, jm:  size of matrix g
c	   * fltpath: type character, path name for filter files (phi, x, y)
c
c	On output:
c	   gflt:


#include <fltxy.h>

        character*(*) fltpath

        integer im,jm
        integer maxscl, j0, len_flt2, multip, m_ext

        real g(im,jm), gflt(im,jm)
        real DM(2,2), detm, arg(2)

        integer i, j, ii, jj, iphi, jphi, ii0, jj0
        real dx, dy

        real gg(-1000:1000, -1000:1000)   ! declare a huge matrix



        call readspline(fltpath)

        call dilat_matrix(detm, DM, j0)         ! quincunx


        dx = 1. / maxscl
        dy = dx

                len_flt2 = abs(x(-nflt2))
                multip = nflt2 / len_flt2

c
c       ============================================
c       Extension by (2^{-j0/2} * nflt2 * maxscl) pts
c       using a symmetric extension scheme
c       ============================================
c
           m_ext = int(len_flt2 * maxscl / 2.0**(j0*0.5)) + 1

        do j = 1, jm
        do i = 1, im
           gg(i,j) = g(i,j)
        enddo
        enddo

        do j = jm+1, 2*jm
        do i = 1, im
           gg(i,j) = g(i, 2*jm-j+1)
        enddo
        enddo

        do j = 1, jm
        do i = im+1, 2*im
           gg(i,j) = g(2*im-i+1, j)
        enddo
        enddo

        do j = jm+1, 2*jm
        do i = im+1, 2*im
           gg(i,j) = g(2*im-i+1, 2*jm-j+1)
        enddo
        enddo

        do j = -m_ext, jm+m_ext
        do i = -m_ext, im+m_ext
                ii0 = mod(i-1, 2*im) + 1
                jj0 = mod(j-1, 2*jm) + 1
                if (ii0 .le. 0) ii0 = ii0 + 2*im
                if (jj0 .le. 0) jj0 = jj0 + 2*jm
           gg(i,j) = gg(ii0, jj0)
        enddo
        enddo
c
c       ============================================
c

        do j = 1, jm
        do i = 1, im
           gflt(i,j) = 0.
c             do jj = 1, jm     ! zero-padding ext used. NOT GOOD!
c             do ii = 1, im

              do jj = -m_ext, jm+m_ext
              do ii = -m_ext, im+m_ext
                 arg(1) = DM(1,1) * (i-ii) + DM(1,2) * (j-jj)
                 arg(2) = DM(2,1) * (i-ii) + DM(2,2) * (j-jj)
                 arg(1) = arg(1) / maxscl
                 arg(2) = arg(2) / maxscl

                 if (abs(arg(1)) .le. len_flt2 .and.
     +               abs(arg(2)) .le. len_flt2) then

                 iphi = int(arg(1) * multip)
                 jphi = int(arg(2) * multip)

                 gflt(i,j) = gflt(i,j) + gg(ii,jj) * phi(iphi, jphi)

                 endif

              enddo
              enddo

           gflt(i,j) = gflt(i,j) * detm * dx * dy
        enddo
        enddo


	return
	end

