
c 	Pre-process all the necessary data for a multi-scale EVA.
c	The processing includes extraction of relevant data series
c	from the HOPS generated file and the performing of three
c	transforms of them.
c	All the obtained series are stored in the directory ./Data/
c
c    -- Extension type -------
        integer ext_id 
c    -------------------------

c     -- Delimits for domain for analysis --------
c     --    i = ix0 ~ ix1,  j = jy0 ~ jy1, k = kp.
	integer ix0, ix1, jy0, jy1, kp
c     --------------------------------------------

c     ----- Basic profiles -------
	real dena_mean(km), s(km), dlogsz(km)
c     ----------------------------

c     ----- File name of HOPS output, and path of pre-processed data -----
	character*80 fname, evapath
c     ----------------------------------------------

c     ----- Grids parameters -----
	real dx, dy, dz(km), dt
c     ----------------------------
 
	common /extension/ext_id

	common /delimits/ ix0, ix1, jy0, jy1, kp

	common /bas_prof/dena_mean, s, dlogsz

        common /datafile/fname, evapath

	common /grids/dx, dy, dz, dt


c     ------ The following lines are added on April 5, 2004 ------
c     ------  sdflux: surface density flux 
c     ------  smflux: surface momentum flux
c     ------  fkph:   background eddy diffusion coef for tracers
c     ------  fkpm:   background eddy viscocity for momentum
c     ------  wdmix:  eddy mixing coef in mixing layer for tracer
c     ------  wvmix:  eddy mixing coef in mixing layer for mom.
c     ------  depth_mix:  depth of mixed layer, a function of
c                         wind stress smflux and MLDOPT
c
	real sdflux(im,jm), smflux(im,jm), depth_mix(im,jm)
	real MLDOPT, fkph, fkpm, wdmix, wvmix

	common /surfflux/sdflux, smflux, depth_mix,
     +		MLDOPT, fkph, fkpm, wdmix, wvmix
	
