
c	
c	Perform the analysis of series p and q
c	which have the synthesized seires z1_bar, z1(prime), z1(double prime),
c	and z2_bar, z2(prime), and z2(double prime).
c	
c	The newly generated series are to be named
c	pg00, pg01, pg10, etc..


	subroutine interact_anal(z1_bar, z1_prime, z1_dprime,  
     +		   z2_bar, z2_prime, z2_dprime, p, q)
#include <config.h>
#include <wt_1d.h>
#include <input.h>

	real z1_bar(im,jm,nm), z1_prime(im,jm,nm), z1_dprime(im,jm,nm)
	real z2_bar(im,jm,nm), z2_prime(im,jm,nm), z2_dprime(im,jm,nm)
	
	character*(*) p, q


	call proc_prt(z1_bar, z2_bar,    p, q, '00')
	call proc_prt(z1_bar, z2_prime,  p, q, '01')
	call proc_prt(z1_bar, z2_dprime, p, q, '02')

	call proc_prt(z1_prime, z2_bar,    p, q, '10')
	call proc_prt(z1_prime, z2_prime,  p, q, '11')
	call proc_prt(z1_prime, z2_dprime, p, q, '12')

	call proc_prt(z1_dprime, z2_bar,    p, q, '20')
	call proc_prt(z1_dprime, z2_prime,  p, q, '21')
	call proc_prt(z1_dprime, z2_dprime, p, q, '22')

	return
	end




	subroutine proc_prt(z1, z2, p, q, suffix)
#include <config.h>
#include <wt_1d.h>
#include <input.h>

	character*(*) p, q, suffix

	real z1(im, jm, nm)
	real z2(im, jm, nm)

	real zz(0 : nxm1)
        real zz_prime(0:nxm1), zz_bar(0:nxm1), zz_dprime(0:nxm1)
        real zzwt_0(0:nxm1), zzwt_01(0:nxm1), zzwt_12(0:nxm1)

	real fwt_0(im, jm, nloc2)
	real fwt_01(im, jm, nloc2)
	real fwt_12(im, jm, nloc2)

	real var(im, jm)
        common /tmpfiles/var

	integer i, j, nt


	do j = jy0, jy1
	do i = ix0, ix1

	    do nt = 1, nm
	    zz(nt - 1) = z1(i, j, nt) * z2(i, j, nt)
	    enddo


        call proc_pt(zz, zz_bar, zz_prime, zz_dprime,
     +               zzwt_0, zzwt_01, zzwt_12,
     +               j0, j1, ext_id, 0)

	     do nt = 1, nloc2
	     fwt_0(i, j, nt) = zzwt_0(loc0(nt)-1)
	     fwt_01(i, j, nt) = zzwt_01(loc1(nt)-1)
	     fwt_12(i, j, nt) = zzwt_12(loc2(nt)-1)
	     enddo

	enddo
	enddo


	call out_aid(evapath, p//q//suffix//'wt_0', fwt_0, kp, 
     +		im, jm, nloc2, var, ix0, ix1, jy0, jy1)
	
	call out_aid(evapath, p//q//suffix//'wt_01', fwt_01, kp, 
     +		im, jm, nloc2, var, ix0, ix1, jy0, jy1)

	call out_aid(evapath, p//q//suffix//'wt_12', fwt_01, kp, 
     +		im, jm, nloc2, var, ix0, ix1, jy0, jy1)

	return
	end
