c       Pre-process the dataset to calculate all the transformed 
c	series necessary for the MS-EVA diagnostics.
c       Results stored in directory ./Data/


	program pre_process

#include <config.h>
#include <wt_1d.h>
#include <input.h>
#include <pre-process.h>

	real tmp1_bar(im,jm,nm), tmp2_bar(im,jm,nm)
	real tmp1_prime(im,jm,nm), tmp2_prime(im,jm,nm)
	real tmp1_dprime(im,jm,nm), tmp2_dprime(im,jm,nm)

	integer i, j, nt


	call para_input

        call loc_assign

        call read_wt_gadget

c    ------- Extract and modify principal fields -------
	call xtr_mod (rho, 'dena', kp, 1)
	call xtr_mod (w, 'wvzt', kp, 1)
	call xtr_mod (u, 'vtot', kp, 1)
	call xtr_mod (v, 'vtot', kp, 2)
c	call xtr_mod (tmp, 'temp', kp, 1)
	call xtr_mod (p, 'salt', kp, 1)

c    --- Process and output rho, u, v, w ---------
	
	call transf_surf(rho, r_bar, r_prime, r_dprime)
	call prt_all('r', 1)

	     call prt_pm('r')

	call transf_surf(p, p_bar, p_prime, p_dprime)
	call prt_all('p', 1)

	call transf_surf(w, w_bar, w_prime, w_dprime)
	call prt_all('w', 1)

	call transf_surf(u, u_bar, u_prime, u_dprime)
	call prt_all('u', 1)

	     call prt_pm('u')

	call transf_surf(v, v_bar, v_prime, v_dprime)
	call prt_all('v', 1)

	     call prt_pm('v')

c	call transf_surf(tmp, z_bar, z_prime, z_dprime)
c	call prt_all('temp', 1)





c    ---- Calculate the derived fields ----

c    ---- Calculate analysis of (u*rho), (v*rho), (w*rho) -----
c    --- located resp. at (i+0.5,j,k), (i,j+0.5,k), (i,j,k) ---
c    ----------- note w*rho is not at (i,j,k+0.5) -------------

	call pos_rearrange (tmp1_bar, u_bar, 2, -1)
	call pos_rearrange (tmp1_prime, u_prime, 2, -1)
	call pos_rearrange (tmp1_dprime, u_dprime, 2, -1)
	
	call pos_rearrange (tmp2_bar, r_bar, 1, 1)
	call pos_rearrange (tmp2_prime, r_prime, 1, 1)
	call pos_rearrange (tmp2_dprime, r_dprime, 1, 1)

        call interact_anal(tmp1_bar, tmp1_prime, tmp1_dprime,
     +       tmp2_bar, tmp2_prime, tmp2_dprime, 'u', 'r')


	call pos_rearrange (tmp1_bar, v_bar, 1, -1)
	call pos_rearrange (tmp1_prime, v_prime, 1, -1)
	call pos_rearrange (tmp1_dprime, v_dprime, 1, -1)
	
	call pos_rearrange (tmp2_bar, r_bar, 2, 1)
	call pos_rearrange (tmp2_prime, r_prime, 2, 1)
	call pos_rearrange (tmp2_dprime, r_dprime, 2, 1)

        call interact_anal(tmp1_bar, tmp1_prime, tmp1_dprime,
     +       tmp2_bar, tmp2_prime, tmp2_dprime, 'v', 'r')


	if (kp .gt. 1) then
	   call xtr_mod (wm1, 'wvzt', kp-1, 1)
	   call transf_surf(wm1, wm1_bar, wm1_prime, wm1_dprime)
	else
	   do nt = 1, nm
	   do j = 1, jm
	   do i = 1, im
	      wm1(i,j,nt) = 0.
	      wm1_bar(i,j,nt) = 0.
	      wm1_prime(i,j,nt) = 0.
	      wm1_dprime(i,j,nt) = 0.
	   enddo
	   enddo
	   enddo
	endif

	do nt = 1, nm
	do j = 1, jm
	do i = 1, im
	   tmp1_bar(i,j,nt) = wm1_bar(i,j,nt) + w_bar(i,j,nt)
	   tmp1_prime(i,j,nt) =wm1_prime(i,j,nt) + w_prime(i,j,nt)
	   tmp1_dprime(i,j,nt)=wm1_dprime(i,j,nt)+w_dprime(i,j,nt)
	
	   tmp1_bar(i,j,nt) = tmp1_bar(i,j,nt)  * 0.5
	   tmp1_prime(i,j,nt) = tmp1_prime(i,j,nt)  * 0.5
	   tmp1_dprime(i,j,nt) = tmp1_dprime(i,j,nt)  * 0.5
	enddo
	enddo
	enddo


        call interact_anal(tmp1_bar, tmp1_prime, tmp1_dprime,
     +       r_bar, r_prime, r_dprime, 'w', 'r')


        call interact_anal(r_bar, r_prime, r_dprime,
     +       r_bar, r_prime, r_dprime, 'r', 'r')
c     ---------------------------------------------------------



c    ---- Calculate analysis of (u*u), (v*u), (w*u) -----
c    ---- 			(u*v), (v*v), (w*v) -----
c    --------- all located at (i+0.5,j+0.5,k) -----------

        call interact_anal(u_bar, u_prime, u_dprime,
     +       u_bar, u_prime, u_dprime, 'u', 'u')

        call interact_anal(v_bar, v_prime, v_dprime,
     +       u_bar, u_prime, u_dprime, 'v', 'u')


        call interact_anal(u_bar, u_prime, u_dprime,
     +       v_bar, v_prime, v_dprime, 'u', 'v')

        call interact_anal(v_bar, v_prime, v_dprime,
     +       v_bar, v_prime, v_dprime, 'v', 'v')


	call pos_rearrange(tmp2_bar, tmp1_bar,1,1)
	call pos_rearrange(tmp2_prime, tmp1_prime,1,1)
	call pos_rearrange(tmp2_dprime, tmp1_dprime,1,1)

	call pos_rearrange(tmp1_bar, tmp2_bar,2,1)
	call pos_rearrange(tmp1_prime, tmp2_prime,2,1)
	call pos_rearrange(tmp1_dprime, tmp2_dprime,2,1)


        call interact_anal(tmp1_bar, tmp1_prime, tmp1_dprime,
     +       u_bar, u_prime, u_dprime, 'w', 'u')

        call interact_anal(tmp1_bar, tmp1_prime, tmp1_dprime,
     +       v_bar, v_prime, v_dprime, 'w', 'v')
	
c     ---------------------------------------------------------


	stop
	end


