c ----- invert the Laplacian 
c -----
c -----     gradh^2 P_bt = D
c -----
c ----- for P_bt on a rectangular domain with Neumman BC 
c ----- plus p_bt(2,2) = 0 (the computational domain is 
c -----     	 [2 ~ (im-1),   2 ~ (im-1)] 
c ----- and the p_bt on the outer boundary is obtained
c ----- by extropolation.  ---------------------------


        subroutine calc_pbt

#include <pres.h>
c
      integer i,ihb,ihbp1,j,kamend,kk1,kk2,kk3,kk4,kk5,no
      real    za1,za2,za3,za4,za5
	double precision za(maxband,ndim), zb(ndim)
	real yl(im,jm), yr(im,jm), xl(im,jm), xr(im,jm)
	real xxyy(im,jm), zf(im,jm) 
	integer lpivot(ndim), logrp(ndim)

c	logical rightbpt, leftbpt, topbpt, botbpt


	do j = 1, jm
	do i = 1, im

	if (mask(i,j) .eq. 0) then

	zf(i,j) = (mask(i+1,j) * CJx(i,j) - 
     +		   mask(i-1,j) * CJx(i-1,j)) / dx
        zf(i,j) = zf(i,j) + (mask(i,j+1) * CJy(i,j) -
     +		             mask(i,j-1) * CJy(i,j-1)) / dy
        zf(i,j) = CD(i,j) - zf(i,j)
 
        yl(i,j) = (1. - mask(i,j-1)) / dy/dy
        xl(i,j) = (1. - mask(i-1,j)) / dx/dx
        xr(i,j) = (1. - mask(i+1,j)) / dx/dx
        yr(i,j) = (1. - mask(i,j+1)) / dy/dy
        xxyy(i,j) = yl(i,j) + xl(i,j) + xr(i,j) + yr(i,j)
	xxyy(i,j) = - xxyy(i,j)

	endif

	enddo
	enddo

c
c------------Formation of the algebra equation set------------
c
        do 762 i=1,ndim
        do 762 j=1,maxband
762     za(j,i)=0.
 
        ihb = (maxband0-1)/2
        ihbp1 = ihb+1

        do 200 no = 1, ndim0
             i = ii(no)
             j = jj(no)
 
	zb(no) = zf(i,j)

        za1 = yl(i,j)
        za2 = xl(i,j)
        za4 = xr(i,j)
        za5 = yr(i,j)
	za3 = xxyy(i,j)


        kamend=min0(-no+ihbp1,0)

        kk1=knotnum(i,j-1)+kamend
        kk2=knotnum(i-1,j)+kamend
        kk3=knotnum(i,j)+kamend
        kk4=knotnum(i+1,j)+kamend
        kk5=knotnum(i,j+1)+kamend
 
        if(kk1.gt.0)za(kk1,no)=za1
        if(kk2.gt.0)za(kk2,no)=za2
                    za(kk3,no)=za3
        if(kk4.gt.0)za(kk4,no)=za4
        if(kk5.gt.0)za(kk5,no)=za5

200     continue
	
c-------------------------------------------------------------
 
 
	call band_pivot (ndim0, maxband0, za, zb, logr, logrp,
     +                   ndim, maxband, lpivot)

 
        do no=1,ndim0
           i=ii(no)
           j=jj(no)
           p_bt(i,j) = zb(no)
	enddo


	call extrapo(p_bt, mask)


	return
	end



