	function dena_mean(dpth)
c
c	DENA extracted from std mean profile at (flat) level z=dpth 
c	for MS-EVA analysis.
c
c	On input:
c	   dpth: the vert. coord. (positive, in meters)
c
c	On output:
c	   dena_mean: the mean profile of density anomaly. 
c
c
#include <pres.h>
c
      integer k0,k1
      real    dpth
      real dena_mean
c
	k0 = int(dpth)
	k1 = k0 + 1
c
	dena_mean = dena_std(k0) + (dena_std(k1)-dena_std(k0))*(dpth-k0)
c
	return
	end
