	subroutine extrapo(var, land0)
c
c ----- Extrapolate a variable outside boundary points --------
c
c	On input:
c	   VAR:    2-D variable (im, jm)
c	   LAND0:   landt, landv, or mask
c	On output:
c	   VAR:    extrapolated 2-D variable
c
#include <pres.h>
c
      integer i,j
	integer land0(im,jm)
	real var(im,jm) 

	logical rightbpt, leftbpt, topbpt, botbpt


        do j = 2, jm-1
        do i = 2, im-1
           rightbpt = land0(i+1,j) .eq. 1
           leftbpt  = land0(i-1,j) .eq. 1
           topbpt  = land0(i,j+1) .eq. 1
           botbpt  = land0(i,j-1) .eq. 1
        if (land0(i,j) .eq. 0 .and. (rightbpt .or. leftbpt .
     +      or. topbpt .or. botbpt)) then

           if(rightbpt) then
             var(i+1, j) = var(i,j)
               elseif (leftbpt) then
                 var(i-1, j) = var(i,j)
                   elseif (topbpt) then
                 var(i,j+1) = var(i,j)
               else
             var(i,j-1) = var(i,j)
           endif
             if (leftbpt .and. botbpt)  var(i-1, j-1) = var(i,j) 
             if (rightbpt .and. botbpt) var(i+1, j-1) = var(i,j) 
             if (topbpt .and. rightbpt) var(i+1, j+1) = var(i,j) 
             if (leftbpt .and. topbpt)  var(i-1, j+1) = var(i,j)

        endif
        enddo
        enddo

        return
        end

c ------------------------------------------------------------
c  The following uses a different extrapolation scheme. But
c  it turns out not as good as the above simple one.
c ------------------------------------------------------------
c
c           if(rightbpt) then
c             var(i+1, j) = 2. * var(i,j) - var(i-1,j)
c               elseif (leftbpt) then
c                 var(i-1, j) = 2. * var(i,j) - var(i+1,j)
c                   elseif (topbpt) then
c                 var(i,j+1) = 2. * var(i,j) - var(i,j-1)
c               else
c             var(i,j-1) = 2. * var(i,j) - var(i,j+1)
c           endif
c                var(i-1, j-1) = 2 * var(i,j) - var(i+1,j+1)
c                var(i+1, j-1) = 2 * var(i,j) - var(i-1,j+1)
c                var(i+1, j+1) = 2 * var(i,j) - var(i-1,j-1)
c                var(i-1, j+1) = 2 * var(i,j) - var(i+1,j-1)



