c
c -----	compute CJx, CJy, CD (div of [CJx,CJy)] ------
c
c ----- (CJx, CJy) lie on a staggered mesh grid (Arakawa C) -----
c ----- their indices are (i+1/2, j) and (i, j+1/2) resp. -------
c
	subroutine preproc(nt)
c
#include <pres.h>
c
      integer i,im1,ip1,j,jm1,jp1,k,nm1,np1,nt
      real    H_1,H_2,rk1,rk2,term1,term2,term3,term4,term5,term6,term7,
     &        term8,ub,ub_2,vb,vb_1
c
	real uu2(im,jm), uv2(im,jm), vu2(im,jm), vv2(im,jm)
	real uu(km,im,jm), uv(km,im,jm), vu(km,im,jm), vv(km,im,jm)
	real u(km, im, jm), v(km, im, jm)
	real up(km, im, jm), vp(km, im, jm)
	real um(km, im, jm), vm(km, im, jm)
	real p_bc2(im,jm) 
	real u2p(im,jm), v2p(im,jm)
	real u2m(im,jm), v2m(im,jm)
c	real Hv(im,jm), Ht(im,jm)
 
c
c       --- intgrl limits ----
c
	rk1 = km + 0.5
	rk2 = 0.5
c       ----------------------

c --------- Begin the big loop ----------

	        np1 = nt+1
	        nm1 = nt-1
	   if (np1 .gt. nm) np1 = nm
	   if (nm1 .lt. 1) nm1 = 1

	   do j = 1, jm
	   do i = 1, im
	   do k = 1, km
	      u(k,i,j) = vtot(1,k,i,j,nt)
	      v(k,i,j) = vtot(2,k,i,j,nt)
	      up(k,i,j) = vtot(1,k,i,j,np1)
	      vp(k,i,j) = vtot(2,k,i,j,np1)
	      um(k,i,j) = vtot(1,k,i,j,nm1)
	      vm(k,i,j) = vtot(2,k,i,j,nm1)
	   enddo
	   enddo
	   enddo

	   do j = 1, jm
	      do i = 1, im
	         do k = 1, km
	            uu(k,i,j) = u(k,i,j) * u(k,i,j)
		    vu(k,i,j) = v(k,i,j) * u(k,i,j)
		    uv(k,i,j) = u(k,i,j) * v(k,i,j)
		    vv(k,i,j) = v(k,i,j) * v(k,i,j)
	         enddo
	      enddo
	   enddo
	   call vert_intgr2(uu2, uu, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(vu2, vu, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(uv2, uv, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(vv2, vv, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(p_bc2, p_bc, dzt, rk1,rk2, km,im,jm) 

c	   call vert_intgr2(u2, u, dzv, rk1,rk2, km,im,jm)
c	   call vert_intgr2(v2, v, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(u2p, up, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(v2p, vp, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(u2m, um, dzv, rk1,rk2, km,im,jm)
	   call vert_intgr2(v2m, vm, dzv, rk1,rk2, km,im,jm)

	

	   do j = 1, jm
	   do i = 1, im
	        ip1 = i+1
	        im1 = i-1
	      if (ip1 .gt. im) ip1 = im
	      if (im1 .lt. 1) im1 = 1

	        jp1 = j+1
	        jm1 = j-1
	      if (jp1 .gt. jm) jp1 = jm
	      if (jm1 .lt. 1) jm1 = 1
	
	
	      ub = u(km,i,j) + u(km,i,jm1) 
	      ub = ub * 0.5
	      vb = v(km,i,j) + v(km,im1,j)
	      vb = vb * 0.5

	      vb_1 = (v(km,i,j) + v(km,i,jm1)) / 2.0
	      ub_2 = (u(km,i,j) + u(km,im1,j)) / 2.0

	      H_1 = (Ht(i,j) + Ht(ip1,j)) / 2.0
	      H_2 = (Ht(i,j) + Ht(i,jp1)) / 2.0


c	      term1 = psi(i,jp1,np1) - psi(i,jp1,nm1)
c	      term1 = term1 - (psi(i,jm1,np1) - psi(i,jm1,nm1)) 
c	      term1  = - term1 / (2.*dt) / (2.*dy)

	      term1 = u2p(i,j) - u2m(i,j)
	      term1 = term1 + u2p(i,jm1) - u2m(i,jm1)
	      term1 = term1 / (4. * dt)


	      term2 = (uu2(ip1,j) - uu2(im1,j) + 
     +		       uu2(ip1,jm1) - uu2(im1,jm1)) / (4.*dx)
	      term2 = term2 + (vu2(i,j) - vu2(i,jm1)) / dy


	      term3 = (u(km, ip1,j)**2 - u(km,im1,j)**2 + 
     +		       u(km,ip1,jm1)**2 - u(km,im1,jm1)**2) 
     + 		    * (Ht(ip1,j) - Ht(i,j)) / (4. * dx * dx)
	      term3 = term3 +
     +	           (v(km,i,j)*u(km,i,j) - v(km,i,jm1)*u(km,i,jm1))
     + 	         * (Hv(i,j) - Hv(i,jm1)) / (dy * dy)
	      term3 = - term3


	      term4 = - (w(km,i,j,nt) + w(km,ip1,j,nt)) / 2. * ub

	      term5 = f0 * rho0 / H_1 * 
     +		     (psi(ip1,j,nt) - psi(i,j,nt)) / dx

	      term6 = (p_bc2(ip1,j) - p_bc2(i,j)) / dx

	      term7 = - (p_bc(km,i,j) + p_bc(km,ip1,j)) / 2.0 
     +		      * (Ht(ip1,j)-Ht(i,j)) / dx

	      term8 = - rho0 * cd_bot * sqrt(ub**2 + vb_1**2) * ub 
	      term8 = term8 / H_1


	   CJx(i,j) = -rho0 / H_1 * (term1 + term2 + term3 + term4)
     +		      + term5 - (term6 + term7) / H_1 + term8


              term1 = v2p(i,j) - v2m(i,j)
              term1 = term1 + v2p(im1,j) - v2m(im1,j)
              term1 = term1 / (4. * dt)
 

              term2 = (uv2(i,j) - uv2(im1,j)) / dx
              term2 = term2 + (vv2(i,jp1) - vv2(i,jm1) + 
     +			       vv2(im1,jp1) - vv2(im1,jm1)) / (4.*dy)
 
 
              term3 = (u(km,i,j)*v(km,i,j) - 
     +		       u(km,im1,j)*v(km,im1,j)) 
     +              * (Hv(i,j) - Hv(im1,j)) / (dx * dx) 
              term3 = term3 +
     +             (v(km,i,jp1)**2 - v(km,i,jm1)**2 +
     +		    v(km,im1,jp1)**2 - v(km,im1,jm1)**2)
     +           * (Ht(i,jp1) - Ht(i,j)) / (4. * dy * dy)
              term3 = - term3
 
 
              term4 = - (w(km,i,j,nt) + w(km,i,jp1,nt)) / 2. * vb
 

              term5 = f0 * rho0 / H_2 * 
     +               (psi(i,jp1,nt) - psi(i,j,nt)) / dy
 
              term6 = (p_bc2(i,jp1) - p_bc2(i,j)) / dy
 
              term7 = - (p_bc(km,i,j) + p_bc(km,i,jp1)) / 2.0 
     +                * (Ht(i,jp1)-Ht(i,j)) / dy
 
              term8 = - rho0 * cd_bot * sqrt(ub_2**2 + vb**2) * vb
              term8 = term8 / H_2
 
 
           CJy(i,j) = -rho0 / H_2 * (term1 + term2 + term3 + term4)
     +                + term5 - (term6 + term7) / H_2 + term8


	   enddo
	   enddo




	   do j = 1, jm
	   do i = 1, im
                ip1 = i+1
                im1 = i-1
              if (ip1 .gt. im) ip1 = im
              if (im1 .lt. 1) im1 = 1

                jp1 = j+1
                jm1 = j-1
              if (jp1 .gt. jm) jp1 = jm
              if (jm1 .lt. 1) jm1 = 1

	      CD(i,j) = (CJx(i,j) - CJx(im1,j)) / dx
	      CD(i,j) = CD(i,j) + (CJy(i,j) - CJy(i,jm1)) / dy
	   enddo
	   enddo


c --------- End of the big loop ----------



c	open(1, file='CJy.dat')
c	    do j = 1, jm
c	       write(1, '(83e10.2)') (p_bc(km,i,j),i=1,im)
c	    enddo
c	close(1)
c
c	stop

	return
        end

	
	
