	subroutine setmask
c
c ----- Set the mask file for the domain -----
c       
c	On input:
c	   landt (im,jm):  land mask array 
c
c	On output:
c	   landt: modified land mask array for tracer pts
c	   landv: land mask array for velocity pts derived from landt
c		  (not extracted from PE output)
c	   mask(im,jm):  mask array for the pressure
c
c
#include <pres.h>
c
      integer i,j
c
c	modify landt and landv
c
           do j = 1, jm
           do i = 1, im
              landt(i,j) = 1 - landt(i,j)
	      landv(i,j) = landt(i,j)
           enddo
           enddo



        do j = 1, jm-1
        do i = 1, im-1
           if (landt(i,j) .eq. 0) then
              if (landt(i+1,j) .eq. 1) landv(i,j) = 1
              if (landt(i,j+1) .eq. 1) landv(i,j) = 1
              if (landt(i+1,j+1) .eq. 1) landv(i,j) = 1
           endif
        enddo
        enddo
           do j = 1, jm
              landv(im,j) = 1
           enddo
           do i = 1, im
              landv(i,jm) = 1
           enddo




c	find mask for P

	do j = 1, jm
	do i = 1, im
	mask(i,j) = landt(i,j)
	enddo
	enddo


	do j = 1, jm
	   mask(im,j) = 1
	   mask(1, j) = 1
	enddo

	do i = 1, im
	   mask(i,jm) = 1
	   mask(i, 1) = 1
	enddo


	do j = 2, jm-1
	do i = 2, im-1
	   if (landt(i,j) .eq. 0) then
	      if (landt(i+1,j) .eq. 1) mask(i,j) = 1
	      if (landt(i-1,j) .eq. 1) mask(i,j) = 1


              if (landt(i-1,j-1) .eq. 1) mask(i,j) = 1
              if (landt(i+1,j+1) .eq. 1) mask(i,j) = 1
              if (landt(i+1,j-1) .eq. 1) mask(i,j) = 1
              if (landt(i-1,j+1) .eq. 1) mask(i,j) = 1


	      if (landt(i,j+1) .eq. 1) mask(i,j) = 1
	      if (landt(i,j-1) .eq. 1) mask(i,j) = 1

	   endif

	enddo
	enddo


	return
	end
	

	
