
c	Extract all the variables needed for the pressure computation 
c	and modify all of them to the M.KG.S system.

	subroutine vars_xtr

#include <pres.h>

        integer start(nvdims_set)
        integer count(nvdims_set)

        real fvar
        integer i,ivar,j,k,kk

	real time(2), dxt(2), dyt(2)


	do kk = 1, nvdims_set 
	start(kk) = 1
	count(kk) = 1
	enddo	

	count(1) = 2
	count(2) = km
	count(3) = im
	count(4) = jm
	count(5) = nm
	

        call extract(data_fname, 'vtot', 'NCFLOAT',
     +    nvdims_set, count, start, vtot, ivar)
	

	do kk = 1, nvdims_set
	count(kk) = count(kk+1)
	enddo

        call extract(data_fname, 'wvzt', 'NCFLOAT',
     +    nvdims_set, count, start, w, ivar)


        call extract(data_fname, 'dena', 'NCFLOAT',
     +    nvdims_set, count, start, rho, ivar)




	do kk = 1, nvdims_set
	count(kk) = count(kk+1)
	enddo

        call extract(data_fname, 'pbar', 'NCFLOAT',
     +    nvdims_set, count, start, psi, ivar)



c
c ------------- Read grid paprameters ----------------
c
	count(1) = km
        count(2) = im
        count(3) = jm

	call extract(grd_fname, 'dzt', 'NCFLOAT',
     +	  nvdims_set, count, start, dzt, ivar)

	call extract(grd_fname, 'dzv', 'NCFLOAT',
     +	  nvdims_set, count, start, dzv, ivar)


c
c	------ Calculate tbath and vbath ----
c	=====================================
        do j = 1, jm
        do i = 1, im
           Hv(i,j) = 0.
           Ht(i,j) = 0.
           do k = 1, km
              Hv(i,j) = Hv(i,j) + dzv(k,i,j)
              Ht(i,j) = Ht(i,j) + dzt(k,i,j)
           enddo
	      if (Hv(i,j) .le. 0.) Hv(i,j) = 1.0
	      if (Ht(i,j) .le. 0.) Ht(i,j) = 1.0
        enddo
        enddo
c	=====================================


        count(1) = im
        count(2) = jm

	call extract(grd_fname, 'landt', 'NCLONG',
     +	  nvdims_set, count, start, fvar, landt)


c	call extract(grd_fname, 'landv', 'NCLONG',
c     +	  nvdims_set, count, start, fvar, landv)



	count(1) = 2

	call extract(data_fname, 'time', 'NCFLOAT',
     +	  nvdims_set, count, start, time, ivar)
	  dt = time(2) - time(1)

	call extract(grd_fname, 'dxt', 'NCFLOAT',
     +	  nvdims_set, count, start, dxt, ivar)
		dx = dxt(1)

	call extract(grd_fname, 'dyt', 'NCFLOAT',
     +	  nvdims_set, count, start, dyt, ivar)
		dy = dyt(1)

	count(1) = 1

c	call extract(grd_fname, 'kc', 'NCLONG',
c     +	  nvdims_set, count, start, fvar, kc)

	call extract(data_fname, 'rho0', 'NCFLOAT',
     +	  nvdims_set, count, start, rho0, ivar)

c
c ------------------------------------------------------
c
	return
        end


