	subroutine  zref(z, dz, km, im, jm)
c
c	find the 3D z-coord for pt (k,i,j) (sigma or horiz level)
c	in absolute value. The pt could be tracer pt or velo pt,
c	depending on dz (dzt or dzv).
c
c	On input:
c	   dz (km, im, jm):	    the vertical grid size
c	   (km, im, jm):  limits for (k0,i0,j))
c
c	On output:
c	   z (km,im,jm): 3-D z-coord (positive) for the 
c			 middle level of each vertical grid box. 
c
        integer i,j,k,k0,km, im, jm
	real z(km, im, jm)
	real dz(km, im, jm)
c
	do j = 1, jm
	do i = 1, im
c
	do k0 = 1, km
	   z(k0,i,j) = 0.0
	   do k = 1, k0-1
	   z(k0,i,j) = z(k0,i,j) + dz(k,i,j)
	   enddo
	   z(k0,i,j) = z(k0,i,j) + dz(k0,i,j) / 2.0
	enddo
c
	enddo
	enddo
c
	return
	end	
