c
c=======================================================================
c  Include file "pres.h"
c=======================================================================
#ifndef rmdocinc
c
c  IM      Number of points in the x-direction.
c  JM      Number of points in the y-direction.
c  KM      Number of vertical levels.
c  NM      Number of time levels.
c  KSTD    Number of standard levels for mean profile interpolation.
c
c=======================================================================
#endif
c
      integer im,jm,km,kstd,nm,nvdims_set
      real    g
c
        parameter (im=83, jm=96, km=22, nm=273)
        parameter (g=9.806, kstd=4095)
        parameter (nvdims_set = 6)
c
c	-------------- End of parameter setting --------------
c
      integer maxband,ndim
c
        parameter(ndim = im*jm, maxband = im*2+1)
c
        integer knotnum(im, jm), logr(ndim), ii(ndim), jj(ndim)
	integer mask(im,jm)
c
	character*80 dm_fname, data_fname, grd_fname
c
	real cd_bot, f0, rho0
c
	real zstd(0:kstd), dena_std(0:kstd)
c
c       -----------------------------------------------------------------
c       ------- Interface variables -------
c
        real z(km,im,jm), dx, dy, dt, Q
	real dzt(km,im,jm), dzv(km,im,jm)
c
	integer ndim0, maxband0
	integer landt(im,jm), landv(im,jm)
c
        real vtot(2, km, im, jm, nm)
        real w(km, im, jm, nm)
        real rho(km, im, jm, nm)
        real psi(im, jm, nm)
        real p(km, im, jm, nm)
c
        real p_bc(km, im, jm), p_bt(im, jm)
        real CJx(im, jm), CJy(im, jm), CD(im, jm)
	real Ht(im, jm), Hv(im, jm)
c
	common /files/dm_fname, data_fname, grd_fname
	common /mean_den/zstd, dena_std
	common /grids/z, dzt, dzv, dx, dy, dt, landt, landv, Ht, Hv
c
	common /vars/vtot, w, rho, psi, p, p_bc, p_bt, Q
	common /util/CJx, CJy, CD
c
	common /param/cd_bot, f0, rho0 
c
	common /Lapsolver/ndim0, maxband0, knotnum, logr, ii, jj, mask 
