
c 	This is the DECOMP with only scaling coefs AJJ are computed.
c	Notice that the analysis is not thorough. Only down to a
c	designated level is performed.
c
c
c	1-D fast wavelet transform:
c	Calculate all the expansion coeffs aj, bj from a_{j+1}.
c
c	Required self-defined functions:
c	   int2.f
c	   m2_inv.f
c	   m2_power.f	        
c
c	Inputs:	(Grouped in the file Decomp_1d.in)
c	   (1) Data file aj.dat generated by Jp_analysis.f
c	   (2) 2-D low-pass filter and high-pass filter
c	       h0.dat  and  h1.dat  (with quincunx sampling matrix)
c	   (3) Boundary extensions adopted for x1 and x2 directions
c
c	Outputs:
c	   All the expansion coefficients aj and bj
c	   together with the average of the field (a const)
c	   stored in a file Analysis.dat	
c
c	Author:  X. San Liang
c	Date:	 Sept 22, 2000
c
c       Modified on Dec 14, 2000
c       External func call int2 replaced with original codes
c
c --------------------------------------------------
c
c		Variable specification
c
c	NFLT2: Half length of the filters, provided in h0.dat and h1.dat
c	EFF_LENGTH: Effective (half) Length of the filters
c	H0:    Low-pass filter	
c	H1:    High-pass filter
c	AJP1:  Scaling coefficients at the highest level,
c	       provided by data file aj.dat, the output of Jp_anal_1d.f
c	AJJ:   Scaling coefficients (at all scale levels)
c	BJJ:   wavelet coefficients (at all scale levels)	
c	Z_AVG: average of the field to be analyzed (a const)
c	LEVEL: designated level down to which the analysis is performed.
c
c ---------------------------------------------------

c -------------------------------------------------------------
	subroutine Decomp_ajj(ext_id, z_avg, ajp1, ajj, level)
c	subroutine Decomp(ext_id, z_avg, ajp1, bjp1, ajj, bjj)
c -------------------------------------------------------------
#include <config.h>
#include <wt_1d.h>
c -------------------------------------------------------------

	integer level, ext_id, jm1
	parameter (jm1=jmax-1)
	double precision z_avg
c
c ------------------------------------------
c
	integer j, k, jp1 
	integer lim, k1, mk, ls1_up, ls1_lo, m1, ii0, m01, mm1, indx1
	real dmj, rdmj, sum1, sum2, ajj1, rrr

	real ajp1(0 : kmax)
c	real bjp1(0 : kmax)
	real ajj(kmin : kmax, 0:jmax) 
c	real bjj(kmin : kmax, 0:jmax)


c ------------------------------------------
c -------- With the permitted three types --
c -------- of boundary extensions, all the -
c -------- variables are periodical with ---
c -------- period 2*nx, ie, kmax -----------
c
	do j = jmax, level, -1
	   do k = kmin, kmax
	      ajj(k, j) = 0.
c	      bjj(k, j) = 0.
	   enddo
	enddo

	  do k = 0, kmax
	    ajj(k, jmax) = ajp1(k)
c	    bjj(k, jmax) = bjp1(k)
	  enddo

   	do k = kmin, -1
	   ajj(k, jmax) = ajp1(k+2*nx)
c	   bjj(k, jmax) = bjp1(k+2*nx)
	enddo
c ----------End of initialization-----------





c--------Begin the loop calculating ----------------
c	 a_{j-1}(k) = sum_{m} = h0(m - Mk) * a_j(m)
c---------------------------------------------------

	do j = jm1, level, -1
	   jp1 = j+1
	   lim = 2**j
c          -- lim: dim of the doubled basic coset at scale j ---
	
c          ---------- DMj = DM^{j+1};    RDMj = DMj^{-1} -----------
c          call m2_power(dm, dmj, jp1)
c	   call m2_inv(dmj, rdmj)
	
	   dmj = 2**jp1
	   rdmj = 1. / dmj 

c		write(*,*)'J = ', j

	    do k1 = -lim, lim
c               -----------------------
c               ----  mk  =  M * k ----
c               -----------------------
		mk = 2 * k1 
c               -----------------------------------

c		-----------------------------------------------------
c		--- By the decaying property of h0(m - Mk), 
c		--- the summand will be significant only
c		--- when k lies in [ls1_lo, ls1_up] x [ls2_lo, ls2_up]
c		------------------------------------------------------
		
		ls1_up = eff_length + mk
		ls1_lo = - eff_length + mk
c		------------------------------------------------------


c	        -------------- Sum over m ------------------------		
		   sum1 = 0.
		   sum2 = 0.	

	      do m1 = ls1_lo, ls1_up

c		  ------- Pull m1 back to the extended ------
c		  ------- fundamental coset where ajj takes value--
c		  -------------------------------------------------

c	       cccccccc  m01 = int2(rdmj* m1) cccccccc
                rrr = rdmj * m1
                ii0 = int(rrr)

                if (mod(ii0,2) .eq. 0) then
                   m01 = ii0
                else
                   if (rrr .ge. 0) then
                      m01 = ii0 + 1
                         else
                      m01 = ii0 - 1
                   endif
                endif
c 	       cccccccccccccccccccccccccccccccccccccc


		  mm1 = m1 - dmj*m01
c		  -------------------------------------------------

		  ajj1 = ajj(mm1, jp1)

c		    ----- INDX are arguments for H0 and H1 ----
		    indx1 = m1 - mk
c		    -------------------------------------------

		    if(abs(indx1).le.nflt2)then
		      sum1 = sum1 + h0(indx1) * ajj1
c		      sum2 = sum2 + h1(indx1) * ajj1
		    endif
		enddo

	      ajj(k1,j) = sum1
c	      bjj(k1,j) = sum2
	    enddo

	enddo
c------------------ End of the big loop -------------------

	return

	end
