
c === This is a FORTRAN subroutine to extract  a variable from
c === any HOPS-generated netCDF file. Currently those variables w/ a dim
c === exceeding 10 is ruled out (I bet there is no such variable in
c === HOPS generated output at all). And, only two of the six netCDF 
c === data types (1: NCBYTE, 2: NCCHAR, 3: NCSHORT, 4: NCLONG, 5: NCFLOAT, 
c === 6: NCDOUBLE) are considered. They are NCLONG (4) and NCFLOAT (5). 
c ===
c ===
c Typical shapes of HOPS variables:
c
c     temp(outlev, im, jm, nm)
c     vtot(2, outlev, im, jm, nm)
c
c   where (IM, JM) are the number of grid points in (x, y) directions, resp. 
c   OUTLEV is the number of output levels (not KM, no. of the computed levels)
c   NM is the unlimited dim, time steps integrated.
c   The first dim of VTOT indicates the two components of velocity
c        u = vtot(1, ...)
c	 v = vtot(2, ...)

c
c
c INTERFACE DESCRIPTION: 
c
c Inputs:
c   (1)	fname:    name of the existing netCDF file.
c   (2)	var_name: name of the variable to be extracted.
c   (3)	set_type: Currently only NCLONG and NCFLOAT available. Must be
c		  in accordance with the type of the variable.
c   (4)	nvdims_set: pre-set dimensionality for the variable.
c		  It must not be smaller than NVDIMS, the actual dim.
c		  (But not greater than 10)
c		  If not correct, program will stop for correcting.
c   (5)	start:    Integer vector w/ size NVDIMS_SET
c		  starting indices of the corresponding dim
c   (6)	count:	  Integer vector w/ size NVDIMS_SET. With START 
c		  and COUNT specified, COUNT(i) records will be 
c		  extracted starting from START(i) for dimension I.
c	
c		  The shape(s) of dim(s) beyond NVDIMS must
c	          be set such that START(i)=1, and COUNT(i)=0, for
c		  all NVDIMS < i <= NVDIMS_SET. (Actually this will
c		  be done automatically in subroutine extract.f
c
c Outputs:
c	fvar:     returned variable, if real (NCFLOAT).
c	ivar:     returned variable, if integer (NCLONG).
c
c	          CAUTION:
c	      (1) The type of fvar or ivar must be specified exactly 
c		  the same as the one to be extracted. If not, the 
c		  program will stop for a correction.
c	      (2) The shape of the one to be extracted must be in
c		  accordance with COUNT (actually exactly the same as
c		  COUNT(i)), rather than its real shape
c		  in the HOPS output. For example, if only the temp
c		  at a particular time and a particular level is needed,
c		  then TEMP should be declared as TEMP(im,jm).
c		  (But NVDIMS_SET is still 4, not 2).
c === 
c === Refer to the sample lines about how to use the subroutine EXTRACT
c ===
c ===
c === Author: X. San Liang
c === Date:   January 17, 2000
c === Re-written: November 20, 2000

c

	subroutine extract(fname, var_name, set_type,
     $	       nvdims_set, count, start, fvar, ivar)

#include <netcdf.inc>
c
c=======================================================================
c  Define interface data.
c=======================================================================
	character*(*) 	fname
	character*(*) 	var_name
	character*(*) 	set_type
        integer nvdims_set, count(*), start(*)

c=======================================================================
c  Define global data.
c=======================================================================
	integer 	 dimens
	parameter 	(dimens = 10)
	integer ncid, varid
	integer nvdims, nvatts, vtype, rcode,
     +		dimsiz(dimens), vdims(dimens)
	character*60 dim_name(dimens), var_longname
	

	common /nc_diagn/ dim_name, dimsiz, nvdims
c
c====== nvdims: No. of dims for the variable ============================
c====== dimsiz(dimens): corresponding size of dims. =====================
c
	character*10 nctype(6)
	save nctype
	data nctype/'NCBYTE','NCCHAR','NCSHORT',
     $		    'NCLONG','NCFLOAT','NCDOUBLE'/
c
c
c=======================================================================
c  Define local data.
c=======================================================================
c	integer ivar_addr, fvar_addr, malloc 
c	integer*4 size

 	real fvar(*)
	integer ivar(*)

	integer stdinp, stdout
	parameter (stdinp=5, stdout=6)
	
	integer i 

c=======================================================================
c  Begin executable codes.
c=======================================================================
c

c-----------------------------------------------------------------------
c  Open the existing NetCDF file.
c-----------------------------------------------------------------------
	ncid=ncopn(fname, ncnowrit, rcode)
	  if(rcode.ne.0)then
	    write(stdout,*)' Error in reading file ',fname
	    stop
	  endif

c
c-----------------------------------------------------------------------
c  Get the number of dims and their IDs for var.
c-----------------------------------------------------------------------
c
	varid = ncvid(ncid, var_name, rcode)
	call ncvinq(ncid, varid, var_longname, vtype, 
     +		    nvdims, vdims, nvatts, rcode)


c --------------------------------------------------------------------- 
	do i = 1, nvdims
	   call ncdinq(ncid, vdims(i), dim_name(i), dimsiz(i), rcode)
        enddo
c --------------------------------------------------------------------- 

c	call diagn_inf(var_name, nctype(vtype))
c
	
	if ((vtype.eq.NCLONG) .or. (vtype.eq.NCFLOAT)) then
	  if (nctype(vtype) .ne. set_type) then
	    call exitus_extract(ncid, 'Variable type')
	  endif
	else
	   call exitus_extract(ncid, 'Types (Only NCLONG & NCFLOAT allowed)')
	endif

c
c ------------- Check the shape of the variable to be extracted -------
c ------------- and set the value of COUNT and START at unused dims ---
c
	if (nvdims_set .lt. nvdims) then  
	   call exitus_extract(ncid, 'Variable dimensionality')
	      else
	        do i = nvdims+1, nvdims_set
	        start(i) = 1
	      count(i) = 0
	   enddo
	endif

	do i = 1, nvdims
	if ((start(i)+count(i)-1) .gt. dimsiz(i)) then
	   call exitus_extract(ncid, 'Dimension sizes')
	endif
	enddo
c------------- Shape declaration check completed -------------
	

c------------- Extract the desired variable ------------------

        if (vtype .eq. NCFLOAT) then
            call ncvgt(ncid,varid,start,count,fvar,rcode)
                else 
            call ncvgt(ncid,varid,start,count,ivar,rcode)
        endif

c
c-----------------------------------------------------------------------
c  Close opened NetCDF file.
c-----------------------------------------------------------------------
c
      call ncclos(ncid,rcode)

      return

      end



	subroutine exitus_extract(ncid, reason)
	integer stdout, ncid, rcode
	parameter(stdout=6)
	character*(*) reason 
	write(stdout,'(a)') 'Fatal error: ', reason, ' not correctly set.'
	write(stdout,'(a)')'Program terminated abnormaly.'
	call ncclos(ncid, rcode)
	stop
	end



	subroutine diagn_inf(var_name, var_type)
c ----- Output diagnostical information -------------------
	integer dimens
	parameter(dimens=10)
        integer nvdims, dimsiz(dimens)
        character*60 dim_name(dimens)
	character*10 var_type
	character*(*) var_name
        common /nc_diagn/ dim_name, dimsiz, nvdims

	integer i, stdout

        write(stdout,*)'-----------------------------------------------'
        write(stdout,*)'Name of the variable to be extracted: ',var_name
        write(stdout,*)'NC data type: ', var_type
        write(stdout,*)'Dimensionaality: ', nvdims
        write(stdout,*)'Dim name, size, and order:'
        write(stdout,*)
        do i = 1, nvdims
           write(stdout,*)dim_name(i), ':  ', dimsiz(i)
        enddo

        write(stdout,*)'-----------------------------------------------'
        write(stdout,*)'--- Check if the declaration is correct ... ---'
        write(stdout,*)

	return
	end

