c This is a package to compute the "large-scale", "meso-scale",
c and "small-scale" transforms for a point series. If requested
c only meso-scale transform will be done.

c On input:
c    (0) JMAX: Integer. Max scl level index. must be edited in file wt_1d.h
c	 H0, PHI: Filter bank and scaling function provided up front.
c    (1) Z:    Real 1-D vector. series to be processes, with dim 2^jmax
c    (2) NLOC: Number of expansion coeffs to be outputted.
c    (3) LOC:  1-D integer vector with dim NLOC, holding localities for
c	       the coeffs to be outputted.
c    (4) JJ0:   Scale index for the large-scale feature
c    (5) JJ1:   Scale index for the meso-scale feature
c    (6) EXT_ID: Integer. Extension type. 
c		1: periodical
c		2: symm.	(recommended for general situation)
c		3: anti-symm
c    (7) MESO_ONLY:  a switch, integer const.
c	        1     if only meso-scl transform.
c		0     if all transforms. 

c On output:
c    (1) Z_BAR:    Z bar
c    (2) Z_PRIME:  Z(prime)
c    (3) Z_DPRIME: Z''
c    (4) ZWT_0:    Real, of dim (NMAX). Large-scale exp. coeff. 
c    (5) ZWT_01:        ditto	      . Meso-scale exp. coef.
c    (6) ZWT_12:        ditto         . Sub-mesoscale exp. coef.
c

c===========================================================
c  The following three routines are needed
c
c	Jp_special
c	Decomp_ajj
c	Syn_special
c
c============================================================
	subroutine proc_pt(z, z_bar, z_prime, z_dprime, 
     +     		  zwt_0, zwt_01, zwt_12,
     +	   		  jj0, jj1, ext_id, meso_only)
#include <config.h>
#include <wt_1d.h>

	integer ext_id, meso_only, jj0, jj1

	double precision z_avg
	real z(0 : nxm1)
	real z_bar(0 : nxm1) 
	real z_prime(0 : nxm1) 
	real z_dprime(0 : nxm1) 

	real zwt_0(0:nxm1), zwt_01(0:nxm1), zwt_12(0:nxm1)


c -------------------------------------	
	real ajp1(0 : kmax)
	
	real ajj(kmin : kmax, 0:jmax)

c ------------------------------------

	integer it, nt
	real offset



c --------------- Calculate the three partial reconstructions -------
c ------------------  z_bar,   z_prime,  z_dprime  ------------------

c    If z_avg = 0.0, then no avg performed before transformed, vice versa
c
		z_avg = 1.0
c     ----------------------------------------------------------

	call Jp_special(ext_id, z, ajp1, jmax, z_avg)
	call Decomp_ajj(ext_id, z_avg, ajp1, ajj, jj0)

c     ----------------------------------------------------------
c     --call 
c     --    subroutine Syn_ajj(jj0, a_or_d, de_mean, z_avg,ajj,z)
c     --to reconstruct partially the field
c     --DE_MEAN=1 is chosen to maximize the accuracy.
c
	call Syn_special(jj0, ajj, 1, z_avg, z_bar)
				
	     do it = 0, nxm1
	     z_dprime(it) = (z(it) - z_avg) - z_bar(it)
	     enddo
c
c	-------- Here z_dprime is actually z(prime) + z(double prime) -------
c

c	If output option DE_MEAN=1 is used in calling Syn_ajj,
c	an offset Z_AVG has to be added to the lowest scale reconstruction.
c	In this case, the following lines are to be un-remarked.
c	
	     do it = 0, nxm1
	     z_bar(it) = z_bar(it) + z_avg
	     enddo
c

	     z_avg = 0.0
	call Jp_special(ext_id, z_dprime, ajp1, jmax, z_avg)

	call Decomp_ajj(ext_id, z_avg, ajp1, ajj, jj1)

	call Syn_special(jj1, ajj, 1, z_avg, z_prime)


	     do it = 0, nxm1
	     z_dprime(it) = z_dprime(it) - z_prime(it)
	     enddo


c	==========  Find zwt_01  ==============
	z_avg = 0.0	
	call Jp_special(ext_id, z_prime, ajp1, jmax, z_avg)
	do nt = 0, nxm1
	zwt_01(nt) = ajp1(nt)
	enddo

c
c	----------------------------	
	if (meso_only .eq. 1) return
c	----------------------------	
c


c       ========== Find zwt_0 ======================================
	z_avg = 0.0
	call Jp_special(ext_id, z_bar, ajp1, jmax, z_avg)
c
c       ------------------------------------------------------------
c	Since z_avg !=0  is chosen, the lowest level should be added
c	with a const depending on the level index jj0
c       ------------------------------------------------------------
c
	   offset = 0.0
	if (z_avg .ne. 0) offset = z_avg * 2**(-jmax * 0.5)
c			                   Not -jj0 any longer!
	do nt = 0, nxm1
	zwt_0(nt) = ajp1(nt) + offset
	enddo
c
c       ============================================================
c

c	=========== Find zwt_12 ==========
	z_avg = 0.0
	call Jp_special(ext_id, z_dprime, ajp1, jmax, z_avg)
	do nt = 0, nxm1
	zwt_12(nt) = ajp1(nt)
	enddo
c	==================================


	return

	end



