c
c       JMAX:  The maximal scale index allowed by the series.
c       NFLT2: Half length of the filters, provided in h0.dat and h1.dat
c	NPHI2: Half length of the wavelets, provided in phi.dat and psi.dat
c       EFF_LENGTH: Effective (half) Length of the filters
c -------------------------------------------------------------
c

	integer nflt2, nphi2, eff_length
	integer nx, kmin, kmax, nxm1, jmax

	parameter (jmax=j2)
	parameter (nflt2 = 15)
	parameter (nphi2 = 450)
	parameter (eff_length=12)


        parameter(nx = 2**jmax)
        parameter(kmin = -2*nx, kmax = 2*nx-1)
        parameter(nxm1 = nx-1)

        
        real px(-nphi2 : nphi2)
        real h0(-nflt2 : nflt2), phi(-nphi2 : nphi2)
        character*80 fname_wt(3)

	common /wt_bases/px, phi, h0, fname_wt
 

