c Extract a time series of some field at a single point
c
c On input:
c       fname:  Name of the netCDF file to be extracted from
c	var_name: The variable name to be extracted. 
c		only temp, dena, u, v, w are allowable so far.
c	(ip, jp, kp): The position in the mesh grids.
c	icomp: x-component (1) or y-component? 
c	       (valid only when var_name = 'vtot')
c
c On output:
c        var: The series. 
c	      CAUTION: its dim shape is (0 : nm-1)
c


	subroutine xtr_pt(var, fname, var_name, ip, jp, kp, icomp)
c
#include <config.h>
#include <wt_1d.h>

	integer ndiv, ndiv_dim, nvdims_set, nm1, ip, jp, kp, icomp

     	parameter (ndiv = 2, ndiv_dim = nm/ndiv, nm1 = nm-1)
        parameter (nvdims_set=5)

	character*(*) fname, var_name
	real var(0 : nm1), util(ndiv_dim)

        integer start(nvdims_set)
        integer count(nvdims_set)
c        real fvar ----- ivar not used -----
        integer ivar

	integer jj, jj1, k
c
c  -----Begin excutables-----
	
	do jj = 1, nvdims_set
	start(jj) = 1
	count(jj) = 1
	enddo

	jj1 = 1

	if (var_name .eq. 'vtot') then
	   jj1 = 2
	   start(1) = icomp
	endif

	start(jj1) = kp
	start(jj1+1) = ip
	start(jj1+2) = jp
	count(jj1+3) = ndiv_dim


	do jj = 1, ndiv
	   start(jj1 + 3) = (jj-1) * ndiv_dim + 1
	   call extract(fname, var_name, 'NCFLOAT',
     +	        nvdims_set, count, start, util, ivar)
	   do k = 1, ndiv_dim
	     var(start(jj1+3)-1 + k-1) = util(k)
	   enddo
	enddo

	return
	end
