
	subroutine TQsep (Qx, Qy, Qz, Tx, Ty, Tz, TS, gamma1, gamma2, 
     +		 	  jp, subb, nloc, var_name)

c
c	On input:
c	   var_name: 'r', 'u', or 'v': points to a file
c	       from which var_wt is extracted.
c
c
c	On output:
c	   Qx, Qy, Qz:
c	   Tx, Ty, Tz:
c

#include <config.h>
#include <wt_1d.h>
#include <input.h>
#include <mseva.h>

	integer jp, nloc
	real gamma1, gamma2
	real Qx(im,jm), Qy(im,jm), Qz(im,jm)
	real Tx(im,jm,4), Ty(im,jm,4), Tz(im,jm,4), TS(im,jm,4)

c 	------------------------------------------------------------
        character*(*) subb, var_name

	real tmp1(im,jm,4), tmp2(im,jm,4), tmp3(im,jm,4)
	real util1(im,jm), util2(im,jm), util3(im,jm) 
	real util4(im,jm), util5(im,jm)
	real var_wt(im,jm), varm1_wt(im,jm), varp1_wt(im,jm)
	real wvzv(im,jm), wvzvm1(im,jm)
	real c1, c2, c3, TS_coeff
c
c 	------------------------------------------------------------
	integer itrans, kpm1, kpp1, j, i
	real ut1, ut2, gam1, gam2, ape_coeff  
c 	------------------------------------------------------------
c


                kpm1 = kp - 1
                kpp1 = kp + 1
                if (kpm1 .lt. 1) kpm1 = 1
                if (kpp1 .gt. km) kpp1 = km


		do j = 1, jm
	 	do i = 1, im
		   Qx(i,j) = 0.
		   Qy(i,j) = 0.
		   Qz(i,j) = 0.
		enddo
		enddo


	c1 = 2 * ape_coeff(kpm1)
	c2 = 2 * ape_coeff(kp)		! c = g^2 / (rho0^2 N^2) 
	c3 = 2 * ape_coeff(kpp1)	

	TS_coeff = 0.5 * dlogsz(kp) * c2

c
c	If it is not APE to be calculated, set c1=c2=c3=1, and TS_coeff=0
c 	-----------------------------------------------------------------
c


	call read_wt(var_name//'wt',var_wt,evapath,subb,kp,nloc)
	call read_wt(var_name//'wt',varp1_wt,evapath,subb,kpp1,nloc)
	call read_wt(var_name//'wt',varm1_wt,evapath,subb,kpm1,nloc)

c
c	---------------- calculate Qx, Tx -------------------------
c

	call inter_combine ('u'//var_name, kp, jp, subb, tmp1, nloc)
	call inter_combine (var_name//var_name,kp,jp,subb,tmp2,nloc)


	do itrans = 1, 4
	
	   do j = 1, jm
	   do i = 1, im
	   util1(i,j) = gamma1 * var_wt(i,j) * tmp1(i,j,itrans)
     +	              + gamma2 * uwt(i,j) * tmp2(i,j,itrans)
	   util1(i,j) = - util1(i,j)
	   enddo
	   enddo

	   call gradh (util2, util1, 1)

	   do j = 1, jm
	   do i = 1, im
	   Qx(i,j) = Qx(i,j) + util2(i,j)
	   enddo
	   enddo


	   	do j = 1, jm
	   	do i = 1, im
		   util3(i,j) = tmp1(i,j,itrans)
		enddo
	   	enddo
	   
	   call gradh (util4, util3, 1)
	   call gradh (util3, uwt, 1)

	   do j = 1, jm
	   do i = 1, im
	   Tx(i,j,itrans) = - util2(i,j) - var_wt(i,j) * util4(i,j)
     +		            + 0.5 * tmp2(i,j,itrans) * util3(i,j)
	   enddo
	   enddo	

	enddo

c
c	--------------- calculate Qy and Ty ----------------------
c

        call inter_combine ('v'//var_name, kp, jp, subb, tmp1, nloc)


        do itrans = 1, 4
           do j = 1, jm
           do i = 1, im
           util1(i,j) = gamma1 * var_wt(i,j) * tmp1(i,j,itrans)
     +                + gamma2 * vwt(i,j) * tmp2(i,j,itrans)
           util1(i,j) = - util1(i,j)
           enddo
           enddo

           call gradh (util2, util1, 2)

	   do j = 1, jm
	   do i = 1, im
	   Qy(i,j) = Qy(i,j) + util2(i,j)
	   enddo
	   enddo


           	do j = 1, jm
           	do i = 1, im
           	   util3(i,j) = tmp1(i,j,itrans)
           	enddo
           	enddo
           
           call gradh (util4, util3, 2)
           call gradh (util3, vwt, 2)

           do j = 1, jm 
           do i = 1, im
           Ty(i,j,itrans) = - util2(i,j) - var_wt(i,j) * util4(i,j)
     +                      + 0.5 * tmp2(i,j,itrans) * util3(i,j)
           enddo       
           enddo

        enddo



c
c       --------------- calculate Qz and Tz   ---------------------
c

        call inter_combine ('w'//var_name,  kpm1, jp, subb, tmp1, nloc)
        call inter_combine ('w'//var_name, kp, jp, subb, tmp2, nloc)
        call inter_combine ('w'//var_name,  kpp1, jp, subb, tmp3, nloc)

        call read_wt(var_name//'wt',varm1_wt,evapath,subb,kpm1,nloc)
        call read_wt(var_name//'wt',varp1_wt,evapath,subb,kpp1,nloc)
	

        do itrans = 1, 4

           do j = 1, jm
           do i = 1, im
	   util1(i,j) = - gamma1 * varm1_wt(i,j)*tmp1(i,j,itrans)*c1
	   util2(i,j) = - gamma1 * var_wt(i,j) *tmp2(i,j,itrans)*c2
	   util3(i,j) = - gamma1 * varp1_wt(i,j)*tmp3(i,j,itrans)*c3
	   enddo
	   enddo

	   call gradz(util4, util1, util2, util3)	
	   
	   do j = 1, jm
	   do i = 1, im
	   Qz(i,j) = Qz(i,j) + util4(i,j)
	   enddo
	   enddo

	       do j = 1, jm
	       do i = 1, im
	          util1(i,j) = tmp1(i,j,itrans)
	          util2(i,j) = tmp2(i,j,itrans)
	          util3(i,j) = tmp3(i,j,itrans)
	       enddo
	       enddo

	       call gradz(util5, util1, util2, util3)	


	   do j = 1, jm
	   do i = 1, im
	      Tz(i,j,itrans) = -util4(i,j) - var_wt(i,j)*util5(i,j)*c2
	   enddo
	   enddo
	enddo


        call inter_combine (var_name//var_name,kpm1,jp,subb, tmp1, nloc)
        call inter_combine (var_name//var_name,kp,jp,subb, tmp2, nloc)
        call inter_combine (var_name//var_name,kpp1,jp,subb, tmp3, nloc)

	do itrans = 1, 4

	   do j = 1, jm
	   do i = 1, im
	   ut1 = - gamma2 * wm1_wt(i,j) * 
     +	     (tmp1(i,j,itrans)*c1*dz(kp) + tmp2(i,j,itrans)*c2*dz(kpm1))
     +		   / (dz(kp) + dz(kpm1))

	   ut2 = - gamma2 * wwt(i,j) * 
     +	     (tmp2(i,j,itrans)*c2*dz(kpp1) + tmp3(i,j,itrans)*c3*dz(kp))
     +		   / (dz(kp) + dz(kpp1))

	    util5(i,j) = (ut1 - ut2) / dz(kp)

	    Qz(i,j) = Qz(i,j) + util5(i,j)

	   enddo
	   enddo

	   do j = 1, jm
	   do i = 1, im
	      Tz(i,j,itrans) = Tz(i,j,itrans) - util5(i,j) 
     +		      + 0.5 * tmp2(i,j,itrans) * c2
     +		      * (wm1_wt(i,j) - wwt(i,j)) / dz(kp)
	   enddo
	   enddo

	   do j = 1, jm
	   do i = 1, im
	      TS(i,j,itrans) = TS_coeff * tmp2(i,j,itrans) *
     +		               (wm1_wt(i,j) + wwt(i,j)) * 0.5
	      Tz(i,j,itrans) = Tz(i,j,itrans) - TS(i,j,itrans)
	   enddo
	   enddo

	enddo
        

	do j = 1, jm
	do i = 1, im
	   Qx(i,j) = Qx(i,j) * c2
	   Qy(i,j) = Qy(i,j) * c2
	do itrans = 1, 4
	   Tx(i,j,itrans) = Tx(i,j,itrans) * c2
	   Ty(i,j,itrans) = Ty(i,j,itrans) * c2
	enddo
	enddo
	enddo


	return



c ###################  For velocity components ####################
        entry TQsep_v (Qx, Qy, Qz, Tx, Ty, Tz, gamma1, gamma2,
     +                    jp, subb, nloc, var_name)

                kpm1 = kp - 1
                kpp1 = kp + 1
                if (kpm1 .lt. 1) kpm1 = 1
                if (kpp1 .gt. km) kpp1 = km


		do j = 1, jm
	 	do i = 1, im
		   Qx(i,j) = 0.
		   Qy(i,j) = 0.
		   Qz(i,j) = 0.
		enddo
		enddo


	call read_wt(var_name//'wt',var_wt,evapath, subb,kp, nloc)
	call read_wt(var_name//'wt',varp1_wt,evapath,subb,kpp1,nloc)
	call read_wt(var_name//'wt',varm1_wt,evapath,subb,kpm1,nloc)


	call pos_arrange(util1, wwt, 1, 1)
	call pos_arrange(wvzv, util1, 2, 1)
	call pos_arrange(util1, wm1_wt, 1, 1)
	call pos_arrange(wvzvm1, util1, 2, 1)


c
c	---------------- calculate Qx, Tx -------------------------
c

	call inter_combine ('u'//var_name, kp, jp, subb, tmp1, nloc)
	call inter_combine (var_name//var_name,kp,jp,subb,tmp2,nloc)


	do itrans = 1, 4
	
	   do j = 1, jm
	   do i = 1, im
	   util1(i,j) = gamma1 * var_wt(i,j) * tmp1(i,j,itrans)
     +	              + gamma2 * uwt(i,j) * tmp2(i,j,itrans)
	   util1(i,j) = - util1(i,j)
	   enddo
	   enddo

	   call gradh (util2, util1, 1)
	   call pos_arrange(util1, util2, 1, 1)

	   do j = 1, jm
	   do i = 1, im
	   Qx(i,j) = Qx(i,j) + util1(i,j)
	   enddo
	   enddo


	   	do j = 1, jm
	   	do i = 1, im
		   util3(i,j) = tmp1(i,j,itrans)
		enddo
	   	enddo
	   
	   call gradh (util4, util3, 1)
	        call pos_arrange(util5, util4, 1, 1)
	   call gradh (util3, uwt, 1)
	        call pos_arrange(util4, util3, 1, 1)

	   do j = 1, jm
	   do i = 1, im
	   Tx(i,j,itrans) = - util1(i,j) - var_wt(i,j) * util5(i,j)
     +		            + 0.5 * tmp2(i,j,itrans) * util4(i,j)
	   enddo
	   enddo	

	enddo

c
c	--------------- calculate Qy and Ty ----------------------
c

        call inter_combine ('v'//var_name, kp, jp, subb, tmp1, nloc)


        do itrans = 1, 4
           do j = 1, jm
           do i = 1, im
           util1(i,j) = gamma1 * var_wt(i,j) * tmp1(i,j,itrans)
     +                + gamma2 * vwt(i,j) * tmp2(i,j,itrans)
           util1(i,j) = - util1(i,j)
           enddo
           enddo

           call gradh (util2, util1, 2)
	        call pos_arrange(util1, util2, 2, 1)

	   do j = 1, jm
	   do i = 1, im
	   Qy(i,j) = Qy(i,j) + util1(i,j)
	   enddo
	   enddo


           	do j = 1, jm
           	do i = 1, im
           	   util3(i,j) = tmp1(i,j,itrans)
           	enddo
           	enddo
           
           call gradh (util4, util3, 2)
		call pos_arrange(util5, util4, 2, 1)
           call gradh (util3, vwt, 2)
		call pos_arrange(util4, util3, 2, 1)

           do j = 1, jm 
           do i = 1, im
           Ty(i,j,itrans) = - util1(i,j) - var_wt(i,j) * util5(i,j)
     +                      + 0.5 * tmp2(i,j,itrans) * util4(i,j)
           enddo       
           enddo

        enddo



c
c       --------------- calculate Qz and Tz   ---------------------
c

        call inter_combine ('w'//var_name,  kpm1, jp, subb, tmp1, nloc)
        call inter_combine ('w'//var_name, kp, jp, subb, tmp2, nloc)
        call inter_combine ('w'//var_name,  kpp1, jp, subb, tmp3, nloc)

        call read_wt(var_name//'wt',varm1_wt,evapath,subb,kpm1, nloc)
        call read_wt(var_name//'wt',varp1_wt,evapath,subb,kpp1, nloc)
	

        do itrans = 1, 4
	   do j = 1, jm
	   do i = 1, im
	   util1(i,j) = - gamma1 * varm1_wt(i,j) * tmp1(i,j,itrans)
	   util2(i,j) = - gamma1 * var_wt(i,j) * tmp2(i,j,itrans)
	   util3(i,j) = - gamma1 * varp1_wt(i,j) * tmp3(i,j,itrans)
	   enddo
	   enddo

	   call gradz(util4, util1, util2, util3)	
	   
	   do j = 1, jm
	   do i = 1, im
	   Qz(i,j) = Qz(i,j) + util4(i,j)
	   enddo
	   enddo

	       do j = 1, jm
	       do i = 1, im
	          util1(i,j) = tmp1(i,j,itrans)
	          util2(i,j) = tmp2(i,j,itrans)
	          util3(i,j) = tmp3(i,j,itrans)
	       enddo
	       enddo

	       call gradz(util5, util1, util2, util3)	


	   do j = 1, jm
	   do i = 1, im
	      Tz(i,j,itrans) = - util4(i,j) - var_wt(i,j) * util5(i,j)
	   enddo
	   enddo
	enddo


        call inter_combine (var_name//var_name,kpm1,jp,subb,tmp1,nloc)
        call inter_combine (var_name//var_name,kp,jp, subb,tmp2,nloc)
        call inter_combine (var_name//var_name,kpp1,jp,subb,tmp3,nloc)

	do itrans = 1, 4

	   do j = 1, jm
	   do i = 1, im
	    ut1 = - gamma2 * wvzvm1(i,j) * 
     +	       (tmp1(i,j,itrans) * dz(kp) + tmp2(i,j,itrans) * dz(kpm1))
     +		   / (dz(kp) + dz(kpm1))

	    ut2 = - gamma2 * wvzv(i,j) * 
     +	       (tmp2(i,j,itrans) * dz(kpp1) + tmp3(i,j,itrans) * dz(kp))
     +		   / (dz(kp) + dz(kpp1))

	    util5(i,j) = (ut1 - ut2) / dz(kp)

	    Qz(i,j) = Qz(i,j) + util5(i,j)

	   enddo
	   enddo

	   do j = 1, jm
	   do i = 1, im
	      Tz(i,j,itrans) = Tz(i,j,itrans) - util5(i,j) 
     +			       + 0.5 * tmp2(i,j,itrans)
     +		               * (wvzvm1(i,j) - wvzv(i,j)) / dz(kp)
	   enddo
	   enddo

	enddo
        

	return


	end

