	subroutine gradz(fout, fin_m, fin, fin_p)
c
c	Given a field on 3 consecutive levels, find its vertical gradient
c	fin_m, fin, fin_p: inputs at tracer level kp-1, kp, and kp+1, resp.
c	a rigid-lid is assumed.
c
#include <config.h>
#include <wt_1d.h>
#include <input.h>
	integer kpm1, kpp1, i, j

	real fout(im,jm), fin(im, jm), fin_m(im,jm), fin_p(im,jm)
	real tmp1(im,jm), tmp2(im,jm)


	kpm1 = kp - 1
	kpp1 = kp + 1
	if (kp .eq. km) kpp1 = km
	if (kp .eq. 1) kpm1 = 1

c
c	interpolate onto level kp+0.5, and kp-0.5, resp.
c
        do j = 1, jm
        do i = 1, im
	   if (kp .gt. 1) then
	   tmp1(i,j) = fin(i,j) * dz(kpm1) + fin_m(i,j) * dz(kp)
	   tmp1(i,j) = tmp1(i,j) / (dz(kpm1) + dz(kp))
	       else
	   tmp1(i,j) = 0.
	   endif

	   tmp2(i,j) = fin(i,j) * dz(kpp1) + fin_p(i,j) * dz(kp)
	   tmp2(i,j) = tmp2(i,j) / (dz(kpp1) + dz(kp))
    	enddo
 	enddo
	
	     do j = 1, jm
	     do i = 1, im	
                fout(i,j) = (tmp1(i,j) - tmp2(i,j)) / dz(kp) 
             enddo
             enddo 
	return
	end

