	subroutine inter_combine (a, kpp, jp, subb, T, nloc)
c
c	Calculate the sub-grouped analyses of interaction terms 'a'.
c
c	Input:
c	   a:    Name of the transformed interaction
c	   kpp:  vertical level
c	   jp:   same as the JP in main program
c	   subb: subscripts of transf data file ('0', '01', or '12')
c	   nloc: day index
c
c	Output
c	   T(:,:,1):   T (s1 -> s)
c	   T(:,:,2):   T (s2 -> s)
c	   T(:,:,3):   T (s1+s2 -> s)
c	   T(:,:,4):   T (s -> s)
c
#include <config.h>
#include <wt_1d.h>
#include <input.h>
	integer is1, is2, is0, is, kpp, jp, nloc, i, j

	real T(im,jm,4)
	real z1(im,jm), z2(im,jm), z3(im,jm)
	
	character*(*) a, subb

	is = jp-1
	is1 = is + 1
	is2 = is + 2
	is1 = mod(is1, 3)
	is2 = mod(is2, 3)

	is0 = is + 48
	is1 = is1 + 48
	is2 = is2 + 48



	call read_wt(a// char(is1) // char(is1) // 'wt',
     +		     z1, evapath, subb, kpp, nloc)
	call read_wt(a// char(is0) // char(is1) // 'wt',
     +		     z2, evapath, subb, kpp, nloc)
	call read_wt(a// char(is1) // char(is0) // 'wt',
     +		     z3, evapath, subb, kpp, nloc)


	do j = 1, jm
	do i = 1, im
	T(i,j,1) = z1(i,j) + z2(i,j) + z3(i,j)
	enddo
	enddo


	call read_wt(a// char(is2) // char(is2) // 'wt',
     +		     z1, evapath, subb, kpp, nloc)
	call read_wt(a// char(is0) // char(is2) // 'wt',
     +		     z2, evapath, subb, kpp, nloc)
	call read_wt(a// char(is2) // char(is0) // 'wt',
     +		     z3, evapath, subb, kpp, nloc)

	do j = 1, jm
	do i = 1, im
	T(i,j,2) = z1(i,j) + z2(i,j) + z3(i,j)
	enddo
	enddo


	call read_wt(a// char(is1) // char(is2) // 'wt',
     +		     z1, evapath, subb, kpp, nloc)
	call read_wt(a// char(is2) // char(is1) // 'wt',
     +		     z2, evapath, subb, kpp, nloc)
	do j = 1, jm
	do i = 1, im
	T(i,j,3) = z1(i,j) + z2(i,j)
	enddo
	enddo


	call read_wt(a// char(is0) // char(is0) // 'wt',
     +		     z1, evapath, subb, kpp, nloc)
	do j = 1, jm
	do i = 1, im
	T(i,j,4) = z1(i,j)
	enddo
	enddo

	return
	end


