
c	Calculate energetic terms of the APE equation for
c	Days 16 - 25.	(unit: m^2 / s^3)
c	
c	The units used is very confusing here because of
c	the ones used in HOPS. What is guarranteed is that
c	the terms last come out in a unit of m^2/s^3.
c
c	Every term in need is calculated and transformed simultaneously, in
c	the same modular with level a dummy argument. In the time
c	direction, only the ten designated locations are considered.
c
c	The factor 2^jmax has been multiplied to all the energetic terms
c	when being printed (in subroutine PRT_EVA).
c


        BLOCKDATA
#include <config.h>
#include <wt_1d.h>
#include <input.h>
#include <mseva.h>
        data nlim/nloc0, nloc1, nloc2/
        data clim/1, 2, 2/
        data sub/'0', '01', '12'/
        data jscale/j0, j1, jmax/

        END

c ==================================================================


	program MSEVA_TERMS
#include <config.h>
#include <wt_1d.h>
#include <input.h>
#include <mseva.h>


c  ---  Rules to name the four analyzed processes T1, T2, T3, T4
c  ---  for each interaction term (called, say, AB).
c  ---
c	Let s  = 0, 1, 2
c	    s1 = (s+1) mod 3
c	    s2 = (s+2) mod3
c	then
c	    T1 = [AB, s1, s1, ...] + [AB, s, s1, ...] + [AB, s1, s, ...]
c	    T2 = [AB, s2, s2, ...] + [AB, s, s2, ...] + {AB, s2, s, ...]
c	    T3 = [AB, s1, s2, ...] + [AB, s2, s1, ...]
c	    T4 = [AB, s, s, ...]
c	that is to say,
c	    T1 ===>  T (s1 -> s)
c	    T2 ===>  T (s2 -> s)
c	    T3 ===>  T (s1+s2 -> s)
c	    T4 ===>  T (s -> s)
c  --------------------------------------------------------------

	integer is, is1, is2, jp, nloc 


	gam1 = 0.5	! coef w/  (vS)~ in TQ separation
	gam2 = 0.0	! coef w/ (S^2)~ 



	call para_input

	call loc_assign
c	call read_wt_gadget


	do jp = 1, 3

	do nloc = 1, nlim(jp)

	call ape_terms(jp, sub(jp)(1:clim(jp)), nloc)


        	is = jp-1
        	is1 = is + 1
        	is2 = is + 2
        	is1 = mod(is1, 3)
        	is2 = mod(is2, 3)

        	is = is + 48
        	is1 = is1 + 48
        	is2 = is2 + 48



  	call prt_eva('TA_x'//char(is1)//char(is), TA_x1, jp, nloc)
  	call prt_eva('TA_x'//char(is2)//char(is), TA_x2, jp, nloc)
  	call prt_eva('TA_x'//char(is1)//char(is2)//char(is), 
     +			TA_x3, jp, nloc)
  	call prt_eva('TA_x'//char(is)//char(is), TA_x4, jp, nloc)



  	call prt_eva('TA_y'//char(is1)//char(is), TA_y1, jp, nloc)
  	call prt_eva('TA_y'//char(is2)//char(is), TA_y2, jp, nloc)
  	call prt_eva('TA_y'//char(is1)//char(is2)//char(is), 
     +			TA_y3, jp, nloc)
  	call prt_eva('TA_y'//char(is)//char(is), TA_y4, jp, nloc)



  	call prt_eva('TA_z'//char(is1)//char(is), TA_z1, jp, nloc)
  	call prt_eva('TA_z'//char(is2)//char(is), TA_z2, jp, nloc)
  	call prt_eva('TA_z'//char(is1)//char(is2)//char(is), 
     +			TA_z3, jp, nloc)
  	call prt_eva('TA_z'//char(is)//char(is), TA_z4, jp, nloc)


  	call prt_eva('SA'//char(is1)//char(is), SA1, jp, nloc)
  	call prt_eva('SA'//char(is2)//char(is), SA2, jp, nloc)
  	call prt_eva('SA'//char(is1)//char(is2)//char(is), 
     +			SA3, jp, nloc)
  	call prt_eva('SA'//char(is)//char(is), SA4, jp, nloc)
c  	call prt_eva('SA', SA, jp, nloc)

  	call prt_eva('BUOY', buoy, jp, nloc)
  	call prt_eva('QA_x', QA_x, jp, nloc)
  	call prt_eva('QA_y', QA_y, jp, nloc)
  	call prt_eva('QA_z', QA_z, jp, nloc)
  	call prt_eva('FA_z', FA_z, jp, nloc)

	call prt_eva('A_dot', A_dot, jp, nloc)
	call prt_eva('APE', APE, jp, nloc)


	
        call ke_terms(jp, sub(jp)(1:clim(jp)), nloc)

        call prt_eva('TK_x'//char(is1)//char(is), TK_x1, jp, nloc)
        call prt_eva('TK_x'//char(is2)//char(is), TK_x2, jp, nloc)
        call prt_eva('TK_x'//char(is1)//char(is2)//char(is),
     +                  TK_x3, jp, nloc)
        call prt_eva('TK_x'//char(is)//char(is), TK_x4, jp, nloc)


        call prt_eva('TK_y'//char(is1)//char(is), TK_y1, jp, nloc)
        call prt_eva('TK_y'//char(is2)//char(is), TK_y2, jp, nloc)
        call prt_eva('TK_y'//char(is1)//char(is2)//char(is),
     +                  TK_y3, jp, nloc)
        call prt_eva('TK_y'//char(is)//char(is), TK_y4, jp, nloc)

        call prt_eva('TK_z'//char(is1)//char(is), TK_z1, jp, nloc)
        call prt_eva('TK_z'//char(is2)//char(is), TK_z2, jp, nloc)
        call prt_eva('TK_z'//char(is1)//char(is2)//char(is),
     +                  TK_z3, jp, nloc)
        call prt_eva('TK_z'//char(is)//char(is), TK_z4, jp, nloc)


        call prt_eva('QK_x', QK_x, jp, nloc)
        call prt_eva('QK_y', QK_y, jp, nloc)
        call prt_eva('QK_z', QK_z, jp, nloc)
        call prt_eva('QP_x', QP_x, jp, nloc)
        call prt_eva('QP_y', QP_y, jp, nloc)
        call prt_eva('QP_z', QP_z, jp, nloc)
        call prt_eva('FK_z', FK_z, jp, nloc)
	
	call prt_eva('K_dot', K_dot, jp, nloc)
	call prt_eva('KE', KE, jp, nloc)


	enddo
	enddo


	end




        subroutine ape_terms(jp, subb, nloc)
c	calculate APE energetic terms
#include <config.h>
#include <wt_1d.h>
#include <input.h>
#include <mseva.h>
c     --------------------------------------------------------

	integer jp, nloc
	character*(*) subb 

	real ape_coeff
	real rpwt(im, jm), rmwt(im, jm)
        real Tx(im,jm,4), Ty(im,jm,4), Tz(im,jm,4), Sape(im,jm,4)

	real coef1, coef2, aaa
	integer nloc, kpm1, kpp1, i, j
	
c	ape_coeff(kp) =
c             1/2 * g/rho0 * 1/s = 1/2 * g^2 / (rho0^2 * N^2) = c / 2
c	coef2 = c
c	      unit:  m^8 / (kg^2 s^2)

	coef1 = g / rho0
	coef2 = 2 * ape_coeff(kp)

c

		kpm1 = kp - 1
		kpp1 = kp + 1
		if (kpm1 .lt. 1) kpm1 = 1
		if (kpp1 .gt. km) kpp1 = km

	   call read_wt('rwt', rwt, evapath, subb, kp, nloc)
	   call read_wt('rwt', rm1_wt, evapath, subb, kpm1, nloc)
	   call read_wt('rwt', rp1_wt, evapath, subb, kpp1, nloc)

	   call read_wt('wwt', wm1_wt, evapath, subb, kpm1, nloc)
	   call read_wt('wwt', wwt, evapath, subb, kp, nloc)

	   call read_wt('uwt', uwt, evapath, subb, kp, nloc)
	   call read_wt('vwt', vwt, evapath, subb, kp, nloc)

	   if (kp .eq. 1) then
	      do j = 1, jm
	      do i = 1, im
	         wm1_wt(i,j) = 0.
	      enddo
	      enddo
	   endif



c	---------- Calculate A_dot --------------------------
	   call read_wt('rpwt', rpwt, evapath, subb, kp, nloc)
	   call read_wt('rmwt', rmwt, evapath, subb, kp, nloc)

	   do j = jy0, jy1
	   do i = ix0, ix1
	      aaa = (rpwt(i,j) - rmwt(i,j)) / 2.0 / dt
	      A_dot(i,j) = (2.*ape_coeff(kp)) * rwt(i,j) * aaa
c		            2.*ape_coeff(kp) = c
	   enddo
	   enddo
c	-----------------------------------------------------


c       ----------- APE, in m^2 / s^2 -----------
	   do j = jy0, jy1
	   do i = ix0, ix1
	   APE(i,j) = ape_coeff(kp) * rwt(i,j)**2
	   enddo
	   enddo
c 	------------------------------------------



	call TQsep (QA_x, QA_y, QA_z, Tx, Ty, Tz, Sape, 
     +			  gam1, gam2, jp, subb, nloc, 'r')


	
	do j = 1, jm
	do i = 1, im
	   TA_x1(i,j) = Tx(i,j,1)
	   TA_x2(i,j) = Tx(i,j,2)
	   TA_x3(i,j) = Tx(i,j,3)
	   TA_x4(i,j) = Tx(i,j,4)

	   TA_y1(i,j) = Ty(i,j,1)
	   TA_y2(i,j) = Ty(i,j,2)
	   TA_y3(i,j) = Ty(i,j,3)
	   TA_y4(i,j) = Ty(i,j,4)

	   TA_z1(i,j) = Tz(i,j,1)
	   TA_z2(i,j) = Tz(i,j,2)
	   TA_z3(i,j) = Tz(i,j,3)
	   TA_z4(i,j) = Tz(i,j,4)

	   SA1(i,j) = Sape(i,j,1)
	   SA2(i,j) = Sape(i,j,2)
	   SA3(i,j) = Sape(i,j,3)
	   SA4(i,j) = Sape(i,j,4)
	enddo
	enddo


c  ----------------------------------------------------------------
	call mixing(FA_z, fkph,wdmix, rwt,rp1_wt,rm1_wt,coef2,sdflux)
c  ----------------------------------------------------------------

	do j = 1, jm
	do i = 1, im
	buoy(i,j) = coef1 * rwt(i,j) * (wwt(i,j) + wm1_wt(i,j)) * 0.5
	enddo
	enddo

c     -----------------------------------------------------------------	

	return
	end






        subroutine ke_terms(jp, subb, nloc)
#include <config.h>
#include <wt_1d.h>
#include <input.h>
#include <mseva.h>
c     --------------------------------------------------------

	integer jp, nloc
	character*(*) subb  

	real upwt(im, jm), umwt(im, jm)
	real vpwt(im, jm), vmwt(im, jm)

	real up1_wt(im,jm), um1_wt(im,jm)
	real vp1_wt(im,jm), vm1_wt(im,jm)
	real tmpu(im,jm), tmpv(im,jm)
 

        real Tux(im,jm,4), Tuy(im,jm,4), Tuz(im,jm,4)
        real Tvx(im,jm,4), Tvy(im,jm,4), Tvz(im,jm,4)
        real Qvx(im,jm), Qvy(im,jm), Qvz(im,jm)
        real Qux(im,jm), Quy(im,jm), Quz(im,jm)


c        real tke_wt(im,jm), tkep_wt(im, jm), tkem_wt(im, jm)
	real pp1_wt(im, jm), pm1_wt(im, jm)

	integer kpm1, kpp1, i, j 
	real aaa, bbb

               kpm1 = kp - 1
                kpp1 = kp + 1
                if (kpm1 .lt. 1) kpm1 = 1
                if (kpp1 .gt. km) kpp1 = km
      

	call read_wt('uwt', uwt, evapath, subb, kp, nloc)
	call read_wt('vwt', vwt, evapath, subb, kp, nloc)
	call read_wt('wwt', wwt, evapath, subb, kp, nloc)


	call read_wt('upwt', upwt, evapath, subb, kp, nloc)
	call read_wt('umwt', umwt, evapath, subb, kp, nloc)
	call read_wt('vpwt', vpwt, evapath, subb, kp, nloc)
	call read_wt('vmwt', vmwt, evapath, subb, kp, nloc)

c	------------- Compute KE -----------------
	do j = jy0, jy1
	do i = ix0, ix1
	   KE(i,j) = uwt(i,j)**2 + vwt(i,j) **2
	   KE(i,j) = KE(i,j) * 0.5
	enddo
	enddo
c	------------------------------------------

c	------------- Compute K_dot --------------
	do j = jy0, jy1
	do i = ix0, ix1
	   aaa = (upwt(i,j) - umwt(i,j)) / 2.0 / dt
	   bbb = (vpwt(i,j) - vmwt(i,j)) / 2.0 / dt
	   K_dot(i,j) = uwt(i,j) * aaa + vwt(i,j) * bbb
	enddo
	enddo
c	------------------------------------------



        if (kp .gt. 1) then

	    call read_wt('wwt', wm1_wt, evapath, subb, kp-1, nloc)

                else

            do j = 1, jm
            do i = 1, im
               wm1_wt(i,j) = 0.
            enddo
            enddo

         endif



	call TQsep_v (Qux, Quy, Quz, Tux, Tuy, Tuz, gam1, gam2,
     +	     jp, subb, nloc, 'u')


	call TQsep_v (Qvx, Qvy, Qvz, Tvx, Tvy, Tvz, gam1, gam2,
     +	     jp, subb, nloc, 'v')


	do j = 1, jm
	do i = 1, im
	   QK_x(i,j) = Qux(i,j) + Qvx(i,j)
	   QK_y(i,j) = Quy(i,j) + Qvy(i,j)
	   QK_z(i,j) = Quz(i,j) + Qvz(i,j)
	 

           TK_x1(i,j) = Tux(i,j,1) + Tvx(i,j,1)
           TK_x2(i,j) = Tux(i,j,2) + Tvx(i,j,2)
           TK_x3(i,j) = Tux(i,j,3) + Tvx(i,j,3)
           TK_x4(i,j) = Tux(i,j,4) + Tvx(i,j,4)

           TK_y1(i,j) = Tuy(i,j,1) + Tvy(i,j,1)
           TK_y2(i,j) = Tuy(i,j,2) + Tvy(i,j,2)
           TK_y3(i,j) = Tuy(i,j,3) + Tvy(i,j,3)
           TK_y4(i,j) = Tuy(i,j,4) + Tvy(i,j,4)

           TK_z1(i,j) = Tuz(i,j,1) + Tvz(i,j,1)
           TK_z2(i,j) = Tuz(i,j,2) + Tvz(i,j,2)
           TK_z3(i,j) = Tuz(i,j,3) + Tvz(i,j,3)
           TK_z4(i,j) = Tuz(i,j,4) + Tvz(i,j,4)
	enddo
	enddo



c     ------------ QP_x, QP_y, and QP_z --------------------------------
	call read_wt('pwt', pwt, evapath, subb, kp, nloc)
	call read_wt('pwt', pp1_wt, evapath, subb, kpp1, nloc)
	call read_wt('pwt', pm1_wt, evapath, subb, kpm1, nloc)

	call Q_terms(QP_x, QP_y, QP_z, pwt, pp1_wt, pm1_wt,
     +	     uwt, vwt, wwt, wm1_wt, kp)

	do j = 1, jm
	do i = 1, im
	QP_x(i,j) = QP_x(i,j) / rho0
	QP_y(i,j) = QP_y(i,j) / rho0
	QP_z(i,j) = QP_z(i,j) / rho0
	enddo
	enddo

c -----------------------------------------------------------------	
               kpm1 = kp - 1
                kpp1 = kp + 1
                if (kpm1 .lt. 1) kpm1 = 1
                if (kpp1 .gt. km) kpp1 = km


        call read_wt('uwt', um1_wt, evapath, subb, kpm1, nloc)
        call read_wt('uwt', up1_wt, evapath, subb, kpp1, nloc)
        call read_wt('vwt', vm1_wt, evapath, subb, kpm1, nloc)
        call read_wt('vwt', vp1_wt, evapath, subb, kpp1, nloc)

        call mixing(tmpu, fkpm, wvmix, uwt, up1_wt, um1_wt, 1., smflux)
        call mixing(tmpv, fkpm, wvmix, vwt, vp1_wt, vm1_wt, 1., smflux)

	do j = 1, jm
	   do i = 1, im
	      FK_z(i,j) = tmpu(i,j) + tmpv(i,j)
	   enddo
	enddo


	return
	end


	subroutine mixing(F_z, wfbackgrd, wfmix, 
     +			  fwt, fwtp, fwtm, coef, sflux)
#include <config.h>
#include <wt_1d.h>
#include <input.h>
#include <mseva.h>
	real F_z(im,jm), wfbackgrd, wfmix, coef, nu 
	real fwt(im,jm), fwtp(im,jm), fwtm(im,jm), sflux(im,jm)

	real z_level, dzm, dzp, tmp1, tmp2
	integer k, km1, kp1, i, j
	
	   z_level = 0.0
	do k = 1, kp
	   z_level = z_level + dz(k)
	enddo
	   z_level = z_level - dz(kp) * 0.5

	km1 = kp - 1
	kp1 = kp + 1
	if (km1 .lt. 1) km1 = 1
	if (kp1 .gt. km) kp1 = km

	dzm = (dz(km1)+dz(kp)) * 0.5
	dzp = (dz(kp1)+dz(kp)) * 0.5
	
	do j = 1, jm
	   do i = 1, im
		
              if (z_level .gt. depth_mix(i,j)) then
                 nu = wfbackgrd
                   else
                 nu = wfmix
              endif

	      tmp1 = nu * (fwtm(i,j) - fwt(i,j)) / dzm
	      tmp2 = nu * (fwt(i,j) - fwtp(i,j)) / dzp

	      if (kp.eq.1) tmp1 = sflux(i,j) / rho0
	      if (kp .eq. km) tmp2 = 0.0

	      F_z(i,j) = (tmp1 - tmp2) / dz(kp) * fwt(i,j)
	      F_z(i,j) = F_z(i,j) * coef

	   enddo
	enddo

	return
	end
c
c =================================================================	
c
	subroutine Q_terms(QT_x, QT_y, QT_z, T, Tp, Tm,
     +		   u, v, w, wm1, kpp)
#include <config.h>
#include <wt_1d.h>
#include <input.h>

	real u(im, jm), v(im, jm), w(im, jm), wm1(im, jm)
	real QT_x(im, jm), QT_y(im, jm), QT_z(im, jm)
	real T(im, jm), Tp(im, jm), Tm(im, jm)
	real tmpu(im, jm), tmpv(im, jm)

	integer kpp, kpp1, kpm1, i, j, ip1, im1, jp1, jm1
	real tkmm, tkpp


        kpp1 = kpp + 1
        kpm1 = kpp - 1
        if (kpp1 .gt. km) kpp1 = km
        if (kpm1 .lt. 1) kpm1 = 1


	do j = 1, jm
	do i = 1, im
	   tmpu(i,j) = u(i,j) * T(i,j)
	   tmpv(i,j) = v(i,j) * T(i,j)
	enddo
	enddo

	do j = 1, jm
	do i = 1, im
	   ip1 = i+1
	   im1 = i-1
	   jp1 = j+1
	   jm1 = j-1
	   if (ip1 .gt. im) ip1 = im	
	   if (jp1 .gt. jm) jp1 = jm	
	   if (im1 .lt. 1) im1 = 1
	   if (jm1 .lt. 1) jm1 = 1

	   QT_x(i,j) = (tmpu(ip1,j) - tmpu(im1,j)) / dx * 0.5
	   QT_y(i,j) = (tmpv(i,jp1) - tmpv(i,jm1)) / dy * 0.5

	   QT_x(i,j) = - QT_x(i,j)
	   QT_y(i,j) = - QT_y(i,j)

	enddo
	enddo


	
	do j = 1, jm
	do i = 1, im
	   tkmm = dz(kpp) * Tm(i,j) + dz(kpm1) * T(i,j)
	   tkmm = tkmm / (dz(kpp) + dz(kpm1))

	   tkpp = dz(kpp) * Tp(i,j) + dz(kpp1) * T(i,j)
	   tkpp = tkpp / (dz(kpp) + dz(kpp1))

	   QT_z(i,j) = (tkmm * wm1(i,j) - tkpp * w(i,j)) / dz(kpp)
	   QT_z(i,j) = - QT_z(i,j)
	enddo
	enddo

	return
	end
c
c =================================================================	
c



