	subroutine pos_arrange(fld_out, fld, idim, incr)
c	
c	Re-arrange the horizontalmesh grid indexing for FLD.
c	
c	On input:
c	   FLD:      the field whose indexing is to be re-arranged
c	   IDIM:     1 if x dim;   2 if y dim;  
c	   INCR:     index increased by INCR/2 in designated dim.
c
c	On output:
c	   FLD_OUT:  the field with grid indexing modified
c
#include <config.h>
#include <wt_1d.h>
#include <input.h>

	real fld (im, jm), fld_out (im, jm)
	integer idim, incr, i, j, ip1, jp1


	if (idim .eq. 1) then
	   do j = 1, jm
	   do i = 1, im
	      ip1 = i + incr
	      if (ip1. lt. 1 .or. ip1 .gt. im) ip1 = i
	      fld_out(i,j) = (fld(i,j) + fld(ip1,j)) * 0.5
	   enddo
	   enddo

	else if (idim .eq. 2) then
	   do j = 1, jm
	   do i = 1, im
	      jp1 = j + incr
	      if (jp1. lt. 1 .or. jp1 .gt. jm) jp1 = j
	      fld_out(i,j) = (fld(i,j) + fld(i,jp1)) * 0.5
	   enddo
	   enddo

	else
	   call exitus(1, 'pos_arrange', 'idim', 'out of limit')
	endif


	return

	end
