
        subroutine m2_power(dm1, dm2, np)
c       2 x 2 matrix DM1 raised to the NP-th power,
c       and stored in DM2 (DM3 not used)
c
c	Input DM1 is unchanged, and both inputs and outputs are real
c
	integer n, np 
        parameter(n=2)
        real dm1(n, n), dm2(n, n), dm3(n, n)

	integer k1, k2, i, j
	real sum


           do k2 = 1, n
           do k1 = 1, n
           dm2(k1, k2) = 0.
           enddo
           enddo
           
           do k1 = 1, n
           dm2(k1, k1) = 1.
           enddo

        do i = 1, np
           
           do k2 = 1, n
              do k1 = 1, n
                 sum = 0.
                 do j = 1, n
                    sum = sum + dm2(k1,j) * dm1(j,k2)
                 enddo
                 dm3(k1, k2) = sum
              enddo
           enddo

           do k2 = 1, n
           do k1 = 1, n
           dm2(k1, k2) = dm3(k1, k2)
           enddo
           enddo

        enddo

        return
        end


