
	function phi2_shape(x, phi, px, nphi2)
c
c	Calculate 2-D scaling/wavelet function at location X
c	X = DM^j - K  should be calculated before the func is called.
c	
c	Interface description:
c	   X:     [x(1), x(2)] is the coord vector 
c	   PHI:   Discretized scaling/wavelet function, w/ dim as follows
c	   PX:    The coords for PHI in either of its two directions
c	   NPHI2: The half length of PX
c
c
c	Author: X. San Liang
c	Date:   May, 2000
c

	integer nphi2 

	real phi_vertex(4), x_vertex(4)
	real phi(-nphi2 : nphi2, -nphi2 : nphi2) 
	real px(-nphi2 : nphi2)
	real x(2), xx(2)

	real dx 
	integer ix0, ix1, iy0, iy1
	real denom, wgt1, wgt2, wgt3, wgt4
	real phip, phi2_shape


	dx = px(2) - px(1)
	dx = 1. / dx
		xx(1) = x(1) * dx
		xx(2) = x(2) * dx
c	ix0 = ifloor(xx(1))
	    ix0 = int(xx(1))
	    if (xx(1).ne.ix0 .and. xx(1) .lt. 0) ix0 = ix0 - 1
	ix1 = ix0 + 1
c	iy0 = ifloor(xx(2))
	    iy0 = int(xx(2))
	    if (xx(2).ne.iy0 .and. xx(2) .lt. 0) iy0 = iy0 - 1
	iy1 = iy0 + 1	

	phi_vertex(1) = phi(ix0, iy0)
	phi_vertex(2) = phi(ix1, iy0)
	phi_vertex(3) = phi(ix1, iy1)
	phi_vertex(4) = phi(ix0, iy1)

	x_vertex(1) = real(ix0)
	x_vertex(2) = real(ix1)
	x_vertex(3) = real(iy0)
	x_vertex(4) = real(iy1)


c	call interpo_rect(phip, xx,  x_vertex, phi_vertex)
c	==============================================================
	    	denom = (x_vertex(2) - x_vertex(1)) * 
     +			(x_vertex(4) - x_vertex(3))
        	wgt1 = (x_vertex(2) - xx(1)) * (x_vertex(4) - xx(2))
        	wgt2 = (xx(1) - x_vertex(1)) * (x_vertex(4) - xx(2))
        	wgt3 = (xx(1) - x_vertex(1)) * (xx(2) - x_vertex(3))
        	wgt4 = (x_vertex(2) - xx(1)) * (xx(2) - x_vertex(3))

        	phip =  wgt1 * phi_vertex(1) + wgt2 * phi_vertex(2) +
     +                  wgt3 * phi_vertex(3) + wgt4 * phi_vertex(4)

        	phip = phip / denom
c	==============================================================

	phi2_shape = phip

	return
	end

	

