        subroutine findknot(knotnum,logr,ii,jj,ndim0,maxband0, 
     +			    ndim,maxband, im,jm,mask,ip,jp)
c
c       Find the mapping and inverse mapping between model domain 
c	coordinates and the row index of the algebraic equation Ax=B, 
c	and the logical ruler for A.
c
c
c	On input:
c	   NDIM, MAXBAND:     the pre-declared matrix size
c	   (IM, JM): horizontal grid line index limits
c	   MASK:     matrix masking the land points.
c		     land pts: 1
c		     water pts: 0
c		     cyclic bound pts: 4 or -4
c	   IP:	     period in x-dimension. (0 if not periodic bc in x)
c	   JP:	     period in y-dimnesion. (0 if not periodic bc in y)
c
c	On output:
c	   LOGR:     logical ruler
c	   KNOTNUM:  mapping (i,j) to the row index of the algebraic eqn.
c	   (II, JJ): inverse map of knotnum
c	   NDIM0:    dimension size for the matrix A
c	   MAXBAND0: band width for the matrix A
c
	integer i,j,k,k1,k2,no,ndim, maxband, im, jm
	integer ndim0, maxband0
	integer knotnum(im,jm), logr(ndim), ii(ndim), jj(ndim) 
	integer mask(im,jm), ip, jp
c
        character*1 dirfirst
        if(ip.ne.0)then
          dirfirst='i'
            else if(jp.ne.0)then
              dirfirst='j'
            else
          dirfirst='i'
          if(im.gt.jm) dirfirst='j'
        end if
c
        do 50 j = 1, jm
        do 50 i = 1, im
50      knotnum(i,j)=0


        no=0

        if(dirfirst .eq. 'i') then

          do 100 j=1,jm 
          do 100 i=1,im
            if(mask(i,j).ne.1)then
            no=no+1
            ii(no)=i
            jj(no)=j
            knotnum(i,j)=no
            end if
100       continue

          do 150 k=1,no
            i=ii(k)
            j=jj(k)
              k1=knotnum(i,j+1)
              k2=knotnum(i+1,j)
                if(k1.ne.0)then
                  logr(k)=k1-k
                    else if(mask(i,j).eq.-4.and.mask(i+1,j).eq.0)then
                      logr(k)=knotnum(i-1+ip,j)-k
                     else if(k2.ne.0)then
                    logr(k)=1
                  else
                logr(k)=0
              end if
150       continue

        else
          do 200 j=1, jm
          do 200 i=1, im
            if(mask(i,j).ne.1)then
            no=no+1
            ii(no)=i
            jj(no)=j
            knotnum(i,j)=no
            end if
200       continue

          do 250 k=1,no
            i=ii(k)
            j=jj(k)
              k1=knotnum(i+1,j)
              k2=knotnum(i,j+1)
                if(k1.ne.0)then
                  logr(k)=k1-k
                    else if(mask(i,j).eq.-4.and.mask(i,j+1).eq.0)then
                      logr(k)=knotnum(i,j-1+jp)-k
                        else if(k2.ne.0)then
                      logr(k)=1
                    else
                  logr(k)=0
                end if
250       continue

        end if



	ndim0 = no
        maxband0 = 0

        do k = 1, ndim0
        if(logr(k) .gt. maxband0) maxband0 = logr(k)
	enddo
        maxband0 = maxband0 * 2 + 1

c      ------------ check array memory declared --------------
        if(ndim0 .gt. ndim .or. maxband0.gt.maxband)then
        write(*,550) ndim0, maxband0
550     format(1x,'ndim0=',i6,10x,'maxband0=',i4/1x,
     +     'NDIM or MAXBAND declared too small.')
	stop
        end if
c      -------------------------------------------------------


        return
        end



