
        parameter (im=83, jm=96, km=22, nm=281)
        parameter (g=9.8, kstd=4095)	! kstd: num of std levels
					! for mean profile interpolation

c	-------------- End of parameter setting --------------



        parameter(ndim = im*jm, maxband = im*2+1)
c
        integer knotnum(im, jm), logr(ndim), ii(ndim), jj(ndim)
	integer mask(im,jm)

	character*80 dm_fname, data_fname, grd_fname
	
	real cd_bot, f0, rho0
	
	real zstd(0:kstd), dena_std(0:kstd)


c       -----------------------------------------------------------------
c       ------- Interface variables -------
        parameter (nvdims_set = 6)

        real z(km,im,jm), dx, dy, dt 
	real dzt(km,im,jm), dzv(km,im,jm)

	integer landt(im,jm), landv(im,jm)

        real vtot(2, km, im, jm, nm)
        real w(km, im, jm, nm)
        real rho(km, im, jm, nm)
        real psi(im, jm, nm)
        real p(km, im, jm, nm)

        real p_bc(km, im, jm), p_bt(im, jm)
        real CJx(im, jm), CJy(im, jm), CD(im, jm)
	real Ht(im, jm), Hv(im, jm)



	common /files/dm_fname, data_fname, grd_fname
	common /mean_den/zstd, dena_std
	common /grids/z, dzt, dzv, dx, dy, dt, landt, landv, Ht, Hv

	common /vars/vtot, w, rho, psi, p, p_bc, p_bt, Q
	common /util/CJx, CJy, CD

	common /param/cd_bot, f0, rho0 

	common /Lapsolver/ndim0, maxband0, knotnum, logr, ii, jj, mask 

