c
	subroutine vert_intgr2(phi_intgr, phi, dz, rk1, rk2, km, im, jm)
c
c	Integration of a field PHI w.r.t. vertical coordinate Z.
c
c	NOTE: This is another version of vert_intgr.f, but for 
c	that here the 3D grid box thickness dz must be supplied.
c
c       Author: X. San Liang
c       Date:   August 24, 2003
c
c	On input:
c	   dz(km,jm,im): 3-D grid box thickness. could be dzt or dzv,
c			 depending on the integration performed.
c	   rk1:	   real. intgr low limit level (may be sth like 2.5)
c	   rk2:	   real. intgr upper limit level   	""
c	   phi(km, im, jm):  integrand
c	   (km, im, jm):     max (k, i, j)
c	
c	On output:
c	   phi_intgr(im, im): the integral
c
c	Also see:	vert_intgr.f
c
c
c	About the placement of rk1 and rk2 - They could be
c	anything of the following level/half level numbers,
c	depending on the integral limit choice:
c		
c	              ----- 0.5
c		        |
c		       -|-  1
c		        |
c		      ----- 1.5
c		        |
c		       -|-
c		        :
c	 	      ----- k-0.5
c			|
c		       -|-  k
c			|
c		      ----- k+0.5
c			|
c			|
c			:
c			:
c		       -|-  km
c		     ------ km+0.5
c		
c
      integer dk,i,im,j,jm,k,k1,k2,km
	real rk1, rk2,rrk1,rrk2, dz(km, im, jm)
	real phi(km, im, jm), phi_intgr(im, jm)

	logical intk1, intk2
	

c
c	Check limit
c
	if ((rk1 .gt. km+0.5  .or. rk1 .lt. 0.5) .or. 
     +	    (rk2 .gt. km+0.5  .or. rk2 .lt. 0.5)) then
	write(6,*)'Error: rk1 and rk2 out of limit (in VERT_INTGR2).'
	endif
c
c	End of limit check.



	dk = 1
	if (rk1 .ge. rk2) dk = -1

	   intk1 = .FALSE.
	if (int(rk1) .eq. rk1) intk1 = .TRUE.
	   intk2 = .FALSE.
	if (int(rk2) .eq. rk2) intk2 = .TRUE.
	


c	begin the loop
c
	do j = 1, jm
	do i = 1, im

	   rrk1 = rk1
	   rrk2 = rk2
	if (intk1) rrk1 = rrk1 + dk * 0.5
	if (intk2) rrk2 = rrk2 - dk * 0.5

	   k1 = nint(rrk1 + dk * 0.5)
	   k2 = nint(rrk2 - dk * 0.5)

	phi_intgr(i,j) = 0.0
	do k = k1, k2, dk
	phi_intgr(i,j) = phi_intgr(i,j) + phi(k,i,j) * (dz(k,i,j)*(-dk))
	enddo

	   k1 = int(rk1)
	   k2 = int(rk2)

	if (intk1) phi_intgr(i,j) = phi_intgr(i,j) 
     +		 + phi(k1,i,j) * dz(k1,i,j)*0.5*(-dk)
	if (intk2) phi_intgr(i,j) = phi_intgr(i,j) 
     +		 + phi(k2,i,j) * dz(k2,i,j)*0.5*(-dk)

	enddo
	enddo
c
c	end the loop


	return
	end

