C 	This subroutine differs from the normal Jp_anl in that
C	   (1) it performs scaling/wavelet transform at any designated
C	          level rather than just the highest level. i.e., JP is
C	          a variable instead of JMAX. 
C	   (2) it does not allow subdivisions or any other overhead which 
C	          may greatly lower the performance.
C	   (3) Do NOT call phi1_shape. Instead, lines of interpolation
C		  are directly incorporated into the loop. This has almost
C		  speed the computation by 10 times! (but map_in_domain
C		  has to be called, or 5 times slower. That appears bizzare!)
C

c ---------------------------------------------------------------
	subroutine Jp_special(ext_id, z, aj, jp, z_avg)
c	subroutine Jp_special(ext_id, z, aj, bj, jp, z_avg)
c ---------------------------------------------------------------
c
c	A simplified version of Jp_special. Periodic and Symm. ext. only.
c
c
c	EXT_ID:   Bound. ext type (Per.=1;   Symm.=2;    Anti-symm.=3.)
c	PHI:	  
c	PSI:
c	PX:
c	ZZ:	  Series to be analyzed
c	Z_AVG:    0.0 if no avg is removed. Any nonzero real number
c		  indicates an avg should be performed before transform

c -----------------------------------------------------------------
#include <config.h>
#include <wt_1d.h>
c -----------------------------------------------------------------

	integer ext_id, jp
	real aj(0 : kmax)
	double precision z_avg 
	real z(0:nxm1), zz(0:nxm1)
c ------------------------------------------------------------------

	integer k, kmax1
	real fac2, fac_norm


	fac2 = real(2**jp)
	fac_norm = sqrt(fac2)

	fac_norm = 1. / fac_norm


C       --------- Remove the average if requested --------
	if (z_avg .ne. 0) then
	  z_avg = 0.
          do k=0,nxm1
          z_avg = z_avg + z(k)
	  enddo

          z_avg = z_avg / (real(nx))

          do k=0,nxm1
          zz(k) = z(k) - z_avg
          enddo

	else
          do k=0,nxm1
          zz(k) = z(k)
          enddo
	  
	endif
C	----------------------------------------------------


	kmax1 = 2 * nx - 1


	do k = 0, nxm1 
	aj(k) = fac_norm * zz(k)
	enddo	

	if (ext_id .eq. 2) then
	   do k = nx+1, kmax1
	   aj(k) = aj(2*nx-k)
	   enddo
	   aj(nx) = aj(nxm1)
	elseif (ext_id .eq. 1) then
	   do k = nx, kmax1
	   aj(k) = aj(k-nx)
	   enddo
	else
	   write(*, *) 'Cannot handle the extension specified.'
	   stop 'Program stopped abnormally.'
	endif


	return
	end
