c This is a fast version of the original Syn_ajj.sub.
c Ideal to be put in large loops.  
c
c	
c	Inputs:
c	   (1)	The output of Decomp_1d.f
c	   (2)  1-D mother scaling function (file phi.dat)
c	   (3)  1-D mother wavelet function (file psi.dat)
c	   (4)
c
c	Outputs:
c	   (1)
c
c	Variable specification
c	   Z:	 Reconstructed field  (Z_AVG removed if de_mean=1)
c	   Z_AVG:average of the field (a const)
c	   AJ:  scaling coefficients output from Jp_special
c	   DE_MEAN: 0 if output not demeaned; 1 otherwise
c	   PHI:  mother scaling function (phi.dat), 
c	         with scope (-nphi2 : nphi2)
c	   PSI:  mother wavelet function (psi.dat),
c		 scope being the same as PHI
c	   PX:   coordinates for PHI/PSI
c	   EFF_LENGTH:  Effective length for phi/psi (in their own coords)
c	   
c	Author:  X. San Liang
c	Date:    Dec. 14, 2000
c

c
c ------------------------------------------------------
       subroutine Syn_special(j, ajj, de_mean, z_avg,z)
c ------------------------------------------------------
c 
c ------------------------------------------------------
#include <config.h>
#include <wt_1d.h>
c ------------------------------------------------------

	integer s, de_mean, j, jp
	parameter (jp = jmax)

	real z(0:nxm1), arg
	double precision z_avg

	real ajj(kmin : kmax, 0:jmax)
c -------------------------------------------------
	integer ls1_lo, ls1_up, k1, ii0, k01, kk1, ix0, ix1
	real dx, dpx, dmj, rdmj, xs, dmx1, sum, rrr, xx
	real fac_norm, phi_jk



	dx = 1./real(nx)


c	j = j0



c ---- Parameters needed in interpolation of phi-----
c
        dpx = px(2) - px(1)
c
c ---------------------------------------------------


c -------------- Determinant of DM -----------------
c ------ and normalization factor |DM|^{j/2} -------
	fac_norm = 2**(j/2.)
c --------------------------------------------------


c ----------- Find DM^j and DM^{-j} ------------
	dmj = 2**j
	rdmj = 1. / dmj
c ----------------------------------------------



	  do s = 0, nxm1
	     xs = s * dx

		dmx1 = dmj * xs

		ls1_lo = int(dmx1) - eff_length
		ls1_up = int(dmx1) + eff_length

	     sum = 0.
	   do k1 = ls1_lo, ls1_up

	     arg = dmx1 - k1

	     if(arg .ge. -eff_length .and. arg .le. eff_length) then

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccc  k01 = int2(rdmj * k1) cccccccccccccccc
		rrr = rdmj * k1
		ii0 = int(rrr)
		
		if (mod(ii0,2) .eq. 0) then
		   k01 = ii0
		else
		   if (rrr .ge. 0) then
		      k01 = ii0 + 1
			 else
		      k01 = ii0 - 1
		   endif
		endif
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc



			kk1 = k1 - (dmj * k01)



                   xx = arg / dpx
c                  ======= ix0 = ifloor(xx) =======
                        ix0 = int(xx)
                        if (xx.ne.ix0 .and. xx .lt. 0) ix0=ix0 - 1
c                  ================================


			
                   ix1 = ix0 + 1
                phi_jk = phi(ix0) + (phi(ix1) - phi(ix0)) * (xx - ix0)
		phi_jk = phi_jk * fac_norm

c		    phi_jk = fac_norm * phi1_shape(arg, phi, px, nphi2)
		    sum = sum + ajj(kk1,j) * phi_jk 

	     endif
	  enddo

	z(s) = sum	
c	if ((a_or_d.eq.1) .and. (de_mean.eq.0)) z(s) = z(s) + z_avg
	if (de_mean.eq.0) z(s) = z(s) + z_avg

	enddo


	return
	end

