c This is a subroutine to calculate the transform of a series
c for a whole level. For a version w/o synthesis, see PROC_SURF
c
c Class higher than proc_pt, and hence proc_pt.sub is needed.
c And, loc_assign must be run before this can be called
c
c
c On input:
c    FLD:  float. 2-D field series to be processed
c    EXT_ID: integer. Bound. extension ID
c    MESO_ONLY: integer. 1 if only meso-scl and 0 if all transforms
c		If meso_only = 1, then only FWT_01 and F_PRIME 
c		will be outputted.
c
c On output:
c    FWT_0:
c    FWT_01:
c    FWT_12:
c    F_BAR:
c    F_PRIME:
c    F_DPRIME:
c
c See also
c       proc_surf
c
c
	subroutine proc2_surf(fld, ext_id, meso_only,
     +  	fwt_0, fwt_01, fwt_12, 
     +		f_bar, f_prime, f_dprime, ix0, ix1, jy0, jy1)
     +		
#include <config.h>
#include <wt_1d.h>


	real fld(im, jm, nm)

	real f_bar(im, jm, nm) 
	real f_prime(im, jm, nm)
	real f_dprime(im, jm, nm)

	real fwt_0(im, jm, nm) 
	real fwt_01(im, jm, nm)
	real fwt_12(im, jm, nm)

        integer ext_id, meso_only, ix0, ix1, jy0, jy1

        real z(0:nxm1)
        real z_prime(0:nxm1), z_bar(0:nxm1), z_dprime(0:nxm1)
        real zwt_0(0:nxm1), zwt_01(0:nxm1), zwt_12(0:nxm1)

	integer ix, jy, nt

c ======================================================================
 
        do jy= jy0, jy1
        do ix= ix0, ix1
c ======================================================================
 
        do nt = 1, nm
        z(nt-1) = fld(ix,jy,nt)
        enddo
 
 
        call proc_pt(z, z_bar, z_prime, z_dprime,
     +               zwt_0, zwt_01, zwt_12,
     +               j0, j1, ext_id, meso_only)
 
c       ================================================================
 
 
        do nt = 1, nm
           fwt_01(ix, jy, nt) = zwt_01(nt-1)
	   f_prime(ix, jy, nt) = z_prime(nt-1)
	enddo


	if (meso_only .ne. 1) then
	   do nt = 1, nm
           fwt_0(ix, jy, nt) = zwt_0(nt-1)
           fwt_12(ix, jy, nt) = zwt_12(nt-1)
	   f_bar(ix, jy, nt) = z_bar(nt-1)
	   f_dprime(ix, jy, nt) = z_dprime(nt-1)
	   enddo

	endif
 
c       ================================================================
c ======================================================================
        enddo
        enddo
 
 
        return
        end


