c Extract a time series of some field at the designated level.
c
c On input:
c       fname:  Name of the netCDF file to be extracted from
c	var_name: The variable name to be extracted. 
c		only temp, dena, u, v, w are allowable so far.
c	kp: The level to be extracted.
c	icomp: x-component (1) or y-component (2)?
c		(valid only when var_name='vtot')
c
c On output:
c        var: The series. 
c


	subroutine xtr_surf(var, fname, var_name, kp, icomp)
c
#include <config.h>
#include <wt_1d.h>

	integer ndiv, ndiv_dim, nvdims_set, kp, icomp

     	parameter (ndiv = 2, ndiv_dim = nm/ndiv)
        parameter (nvdims_set=5)

	character*(*) fname, var_name
	real var(im, jm, nm) 

	real util(im, jm, ndiv_dim)

        integer start(nvdims_set)
        integer count(nvdims_set)

        integer ivar

	integer i, j, jj, jj1, l, nl
c
c  -----Begin excutable codes-----
	
	do jj = 1, nvdims_set
	start(jj) = 1
	count(jj) = 1
	enddo

	jj1 = 1

	if (var_name .eq. 'vtot') then
	   jj1 = 2
	   start(1) = icomp
	endif

	start(jj1) = kp
	count(jj1+1) = im
	count(jj1+2) = jm
	count(jj1+3) = ndiv_dim


	do jj = 1, ndiv
	   start(jj1 + 3) = (jj-1) * ndiv_dim + 1
	   call extract(fname, var_name, 'NCFLOAT',
     +	        nvdims_set, count, start, util, ivar)


	  do l = 1, ndiv_dim
	       nl = start(jj1+3) + l - 1
	    do j = 1, jm
	       do i = 1, im
	 	  var(i,j,nl) = util(i,j,l)
	       enddo
	    enddo
	  enddo


	enddo

	return
	end
