function errrms = checkmld (zmld,zfit);
%
% errrms = checkmld (zmld,zfit);
%
% This function checks the RMS fit of the mixed layer depth.

%-------------------------------------------------------------------------------
% Toss outliers from fit (PE model does protect against this).
%-------------------------------------------------------------------------------

cutval = min(zmld(:));
ind    = find (zfit<cutval);
if ~isempty(ind)
   zfit(ind) = cutval;
end;

cutval = max(zmld(:));
ind    = find (zfit>cutval);
if ~isempty(ind)
   zfit(ind) = cutval;
end;

%-------------------------------------------------------------------------------
% Compute RMS misfit.
%-------------------------------------------------------------------------------

zerr = zmld - zfit;

errrms = sqrt(mean(zerr.*zerr));

clear zerr;
