function [eckfac,zfit] = fit_eckman (fitflg,iguess,zmld,wstrss,lat);
%
% function [eckfac,zfit] = fit_eckman (fitflg,iguess,zmld,wstrss,lat);
%
% This function "best fits" an eckman coefficient to
% in situ mixed layer depths.
%
% ------
% Input:
% ------
%
%    FITFLG....Flag for best fitting.  [0] use IGUESS  [1] least squares
%    IGUESS....Initial Guess.
%    ZMLD......Mixed layer depths at test points.            (cm)
%    WSTRSS....Wind stress at test points.                   (cm/s)
%    LAT.......Latitudes of test points.
%
% -------
% Output:
% -------
%
%    ECKFAC....Fitted Eckman factor.
%    ZFIT......Constructed Mixed layer depths.   (cm)

%-------------------------------------------------------------------------------
% Set useful parameters.
%-------------------------------------------------------------------------------

latmin = 10.0;
omega = 2*pi*(366.25/365.25)/86400; % Earth angular rotation.

%-------------------------------------------------------------------------------
% Scale wind stress.
%-------------------------------------------------------------------------------

%--------------------------------
%--- Compute Coriolis factor. ---
%--------------------------------

wklat = abs(lat);
ind = find (wklat<latmin);
if ~isempty(ind)
   wklat = latmin;
end;
f0 = 2.*omega.*sin(wklat.*pi./180);

%--------------------------
%--- Scale wind stress. ---
%--------------------------

windflux = wstrss./f0;

%-------------------------------------------------------------------------------
% Compute "Eckmann factor".
%-------------------------------------------------------------------------------

if (fitflg | any(isnan(iguess)))
   eckfac = sum(zmld.*windflux)/sum(windflux.*windflux);
 else
   eckfac = iguess(1);
end;

disp (' ');
disp (['Eckman factor:  ',num2str(eckfac,9)]);

%-------------------------------------------------------------------------------
% Compute "fitted" mixed layer depth.
%-------------------------------------------------------------------------------

zfit = eckfac.*windflux;
