function [N,dNdx,d2Ndx2] = Nfn (x);
%
% [N,dNdx,d2Ndx2] = Nfn (x);
%
% This function supplies values of N and its derivatives as a function
% of the second parameter x.  The purpose is to attempt to constrain the
% Niiler-Kraus N coeffecient to the range [0 1].  The particular function
% chosen is N(x) = [1 + cos(x)]/2.  It allows easy inversions at the endpoints.
%
% ------
% Input:
% ------
%
%    X        Dummy parameter to try to constrain N.
%
% -------
% Output:
% -------
%
%    N        Niiler-Kraus buoyancy factor coefficient.
%    DNDX     First derivative of N-coefficient with respect to X.
%    D2NDX2   Second derivative of N-coefficient with respect to X.

cosx   = cos(x);
N      = (1+cosx)./2;
dNdx   = -sin(x)./2;
d2Ndx2 = -cosx./2;
