function x = Ninv (N);
%
% x = Ninv (N);
%
% This function supplies the inverse value of N as a function
% of the second parameter x.  The purpose is to attempt to constrain the
% Niiler-Kraus N coeffecient to the range [0 1].  The particular function
% chosen is N(x) = [1 + cos(x)]/2.  It allows easy inversions at the endpoints
%
% ------
% Input:
% ------
%
%    N        Niiler-Kraus buoyancy factor coefficient.
%
% -------
% Output:
% -------
%
%    X        Dummy parameter to try to constrain N.

arg = 2.*N - 1;
if (abs(arg)>1), arg=arg./abs(arg); end;

x = acos(arg);
