function zmld = mixed_layer (z,t,s,hlat);
%
% function zmld = mixed_layer (z,t,s,hlat);
%
% This function computes the mixed layer depth
% based on changes to the potential density.
%
% ------
% Input:
% ------
%
%    Z......Observation depths.
%    T......Observation temperatures.
%    S......Observation salinity.
%    HLAT...Station latitudes.
%
% -------
% Output:
% -------
%
%    ZMLD...Mixed layer depths.

%-------------------------------------------------------------------------------
% Set target fraction.
%-------------------------------------------------------------------------------

frac = 0.01;

%-------------------------------------------------------------------------------
% Compute potential density anomalies.
%-------------------------------------------------------------------------------

press = sw_pres (z',hlat')';

pden = (sw_pden (s,t,press,0) - 1000);

%-------------------------------------------------------------------------------
% Compute mixed layer depths.
%-------------------------------------------------------------------------------

[nsta mxpts] = size(z);

for n = 1:nsta
   actind = find(~isnan(z(n,:)));
   den0     = pden(n,1);
   den_deep = pden(n,actind(length(actind)));
   dden = abs(pden(n,actind)-den0);
%   target = frac.*abs(den_deep-den0);
   target = frac;

   mldind = min( find(dden>=target) ) - 1;
   if ~isempty(mldind)
      wkind = mldind:(mldind+1);
      zmld(n) = interp1 (dden(wkind),z(n,actind(wkind)),target);
    else
      zmld(n) = z(n,actind(length(actind)));
   end;
end;
