function plot_castMLD (z,t,s,hlat,zmld,zcut);
%
% function plot_castMLD (z,t,s,hlat,zmld,zcut);
%
% This function computes the mixed layer depth
% based on changes to the potential density.
%
% ------
% Input:
% ------
%
%    Z......Observation depths.
%    T......Observation temperatures.
%    S......Observation salinity.
%    HLAT...Station latitudes.
%    ZMLD...Mixed layer depths.
%    ZCUT...Maximum acceptible depth for shallowest data.

%-------------------------------------------------------------------------------
% Set target fraction.
%-------------------------------------------------------------------------------

frac = 0.01;

%-------------------------------------------------------------------------------
% Compute potential density anomalies.
%-------------------------------------------------------------------------------

press = sw_pres (z',hlat)';

pden = (sw_pden (s,t,press,0) - 1000);

%-------------------------------------------------------------------------------
% Compute mixed layer depths.
%-------------------------------------------------------------------------------

[nsta mxpts] = size(z);

h1 = plot(pden',-z','b'); hold on;

for n = 1:nsta
   actind = find(~isnan(z(n,:)));
   mldind = min( find(z(n,actind)>=zmld(n)) ) - 1;
   if ~isempty(mldind)
      wkind = mldind:(mldind+1);
      ptmp = interp1 (z(n,actind(wkind)),pden(n,actind(wkind)),zmld(n));
      h2 = plot ([pden(n,1:mldind) ptmp],-[z(n,1:mldind) zmld(n)],'r');
    else
      zmld(n) = z(n,actind(length(actind)));
      h2 = plot (pden(n,:),-z(n,:),'r');
   end;
end;

set(gca,'FontName','Times','FontSize',12);
legend([h1(1) h2],'Full Column','Mixed Layer');
xlabel('\sigma_\theta');
title (['Mixed Layer criterion:  |\delta \sigma_\theta| <= ',num2str(frac), ...
        ' & Z_o <= ',num2str(zcut),' (m)']);
