c
c=======================================================================
c  Include file "bndata.h"
c=======================================================================
#ifndef rmdocinc
c
c  IMX     number of points in each domain boundary.
c  ITB     time TTBDYO-DT pointer for PBC0,QBC0,TBC0,UBC0 & VBC0
c  ITBM    time TTBDYO-2DT pointer for TBC0,UBC0,VBC0
c  ITBP    time TTBDYO pointer for TBC0,UBC0,VBC0
c  PO      transport and time rate change of vorticity boundary
c          conditions at time TTBDYO.
c  P1      transport and time rate change of vorticity boundary
c          conditions at time TTBDY1.
c  PBC0    transport boundary & near boundary values at times
c          TTBDYO, TTBDYO-DT, TTBDYO-2DT
c  PBC1    transport boundary & near boundary values at time TTBDY1
c  PCANPO  Flag for ability of transport to use Provided-Orlanski BCs
c  QBC0    vorticity boundary & near boundary values at times
c          TTBDYO, TTBDYO-DT, TTBDYO-2DT
c  QBC1    vorticity boundary & near boundary values at time TTBDY1
c  QCANPO  Flag for ability of vorticity to use Provided-Orlanski BCs
c  TO      tracer boundary conditions at time TTBDYO.
c  T1      tracer boundary conditions at time TTBDYO.
c  TBC0    tracer boundary & near boundary values at times
c          TTBDYO, TTBDYO-DT, TTBDYO-2DT
c  TBC1    tracer boundary & near boundary values at time TTBDY1
c  TCANPO  Flag for ability of tracers to use Provided-Orlanski BCs
c  TTBDYO  earlier boundary condition time.
c  TTBDY1  later boundary condition time.
c  UBC0    internal mode U-velocity boundary & near boundary values
c          at times TTBDYO, TTBDYO-DT, TTBDYO-2DT
c  UBC1    internal mode U-velocity boundary & near boundary values
c          at time TTBDY1
c  UO      internal mode U-velocity boundary conditions at time TTBDYO.
c  U1      internal mode U-velocity boundary conditions at time TTBDY1.
c  VBC0    internal mode V-velocity boundary & near boundary values
c          at times TTBDYO, TTBDYO-DT, TTBDYO-2DT
c  VBC1    internal mode V-velocity boundary & near boundary values
c          at time TTBDY1
c  VCANPO  Flag for ability of velocities to use Provided-Orlanski BCs
c  VO      internal mode V-velocity boundary conditions at time TTBDYO.
c  V1      internal mode V-velocity boundary conditions at time TTBDY1.
c  ZUNZ    time rate of vertically averaged zonal forcing boundary
c          conditions for the row to the north.
c  ZUSZ    time rate of vertically averaged zonal forcing boundary
c          conditions for the row to the south.
c  ZVNZ    time rate of vertically averaged meridional forcing boundary
c          conditions for the row to the north.
c  ZVSZ    time rate of vertically averaged meridional forcing boundary
c          conditions for the row to the south.
c
c=======================================================================
#endif
c
      integer itb,itbm,itbp
      integer          imx(4)
      common /ibndata/ itb,itbm,itbp,imx
c
      logical          pcanpo,qcanpo,tcanpo,vcanpo
      common /lbndata/ pcanpo,qcanpo,tcanpo,vcanpo
c
      FLOAT 
     &      ttbdyo
      FLOAT 
     &      uo(ijmx,km,4),vo(ijmx,km,4),to(ijmx,km,4,nt),po(ijmx,2,4),
     &      ttbdy1,u1(ijmx,km,4),v1(ijmx,km,4),t1(ijmx,km,4,nt),
     &      p1(ijmx,2,4),zunz(ijmx,2,4),zusz(ijmx,2,4),zvnz(ijmx,2,4),
     &      zvsz(ijmx,2,4),tbc0(ijmx,km,nt,3,0:2,4),tbc1(ijmx,km,nt,3,4)
     &    ,ubc0(ijmx,km,3,0:2,4),ubc1(ijmx,km,3,4),vbc0(ijmx,km,3,0:2,4)
     &      ,vbc1(ijmx,km,3,4),pbc0(ijmx,3,0:2,4),pbc1(ijmx,3,4),
     &                 qbc0(ijmx,3,0:2,4),qbc1(ijmx,3,4)
      common /fbndata/ ttbdyo,uo,vo,to,po,ttbdy1,u1,v1,t1,p1,zusz,zvsz,
     &                 zunz,zvnz,tbc0,tbc1,ubc0,ubc1,vbc0,vbc1,pbc0,pbc1
     &      ,qbc0,qbc1
c
      integer east,north,south,west
      parameter (west=1,south=2,east=3,north=4)
