c
c=======================================================================
c  Include file "cbiopnh.h"
c=======================================================================
c
#ifdef bioMcGillic
# ifndef rmdocinc
c  ATTH2O1   light attenuation scale of seawater (cm-1).
c  ATTPHY    light attenuation scale of phytoplankton 
c            (liter umole-1 cm-1).
c  BIOPOS    switch to enforce positive biological fields:
c            [0] do not enforce, [1] enforce.
#  if defined codunlim | defined codlim
#   if defined codunlim
c  CDKP      prey response coefficient.                 [(cm^2 m^3)/(s mmole N)]
c  CDKT      temperature response coefficient.             {cm^2/[s (deg C)^2]}
c  CDKZ      depth response coefficient.                   (cm/s)
#   else
c  CDKP      prey response coefficient.                 [(cm m^3)/(mmole N)]
c  CDKT      temperature response coefficient.             [cm/(deg C)^2]
c  CDKZ      depth response coefficient.
#   endif
c  CDSPD     maximum cod cruising speed.                   (cm/s)
c  CDTMAX    maximum preferred temperature for cod.        (deg C)
c  CDTMIN    minimum preferred temperature for cod.        (deg C)
c  CDWMAX    maximum vertical swimming speed.              (cm/s)
c  CDZMAX    maximum water depth for cod                   (cm).
c  CDZMIN    minimum water depth for cod                   (cm).
#  endif
c  CIVLEV    Ivlev grazing constant (l/umoles). 
c            ("civlev" from PNH card 6.)
c  EXPORT    export rate (umoles liter-1 sec-1).
c  FAVE      vertically-integrated f-ratio (non-dimensional).
c  GRAZRM    maximum zooplankton grazing rate (1/s). 
c            ("rm" from PNH card 6.)
c  HSNH4     half saturation constant for ammonium uptake (umoles/l).
c  HSNO3     half saturation constant for nitrate uptake (umoles/l).
c  IBIOUT    output write switches. [0] do not write, [1] write.
c  INH4      index for ammonium in tracer array.
c  INO3      index for nitrate in tracer array.
c  IPHY      index for phytoplankton in tracer array.
c  IZOO      index for zooplankton in tracer array.
c  NH4PR     recycled (NH4) production rate (umoles liter-1 sec-1).
c  NO3INH    strength of ammonium inhibition on nitrate uptake 
c            (l/umoles).
c  NO3PR     new (NO3) production rate (umoles liter-1 sec-1).
c  PARFRAC   fraction of shortwave radiation that is photosynthetically
c  PHOTOINH  photoinhibition parameter (cm^2/cal).
c  PHOTOR0   initial slope of photosynthesis response to light 
c            (cm^2/cal).
c  PHOTORM   maximum photosynthetic rate (1/s).
c  Q1        nitrate nutrient limitation factor (nondimensional).
c  Q2        ammonium nutrient limitation factor (nondimensional).
c  SBLDEP    depth of the "SBL" (cm). Used for computing the vertically
c            integrated f-ratio.
c  SINKFAC   f-ratio sinking rate factor  (cm/s).
c  SINKPHY   sinking rate for phytoplankton (positive down)  (cm/s).
c  ZGRPHY    zooplankton grazing rate (umoles liter-1 sec-1)
c  ZOOEXC1   zooplankton ammonium excretion fraction (nondimensional).
c            ("fslop" from PNH card 6.)
c  ZOOEXP1   fraction of linear zooplankton loss to export (nondimen).
c  ZOOEXP2   fraction of quadratic zooplankton loss to export (nondim).
c  ZOOLR1    linear zooplankton loss rate (1/s). 
c            ("zloss" from PNH card 6.)
c  ZOOLR2    quadratic zooplankton loss rate (1/s l/umoles).
c            ("zloss2" from PNH card 6.)
c
c=======================================================================
c         
# endif
      common /icbiopnh/ biopos,ibiout
      integer biopos,ibiout(20)
c
      common /fcbiopnh/ atth2o1,attphy,civlev,grazrm,hsno3,hsnh4,no3inh,
     *       photorm,photor0,photoinh,sinkphy,sinkfac,parfrac,sbldep,
     *       zoolr1,zoolr2,zooexc1,zooexp1,zooexp2,wsnkphy,
     *       nh4pr,no3pr,zgrphy,export,q1,q2,fave
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       atth2o1,attphy,civlev,grazrm,hsno3,hsnh4,no3inh,
     *       photorm,photor0,photoinh,sinkphy,sinkfac,parfrac,sbldep,
     *       zoolr1,zoolr2,zooexc1,zooexp1,zooexp2,wsnkphy
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       nh4pr(imt,km),no3pr(imt,km),zgrphy(imt,km),export(imt,km),
     *       q1(imt,km),q2(imt,km),fave(imt)
c
      integer inh4,ino3,iphy,izoo
      parameter (ino3=3,iphy=4,izoo=5,inh4=6)
# if defined codunlim | defined codlim | defined cod_ing
      integer icod
      parameter (icod=7)
# endif
#endif
#ifdef bioAnder
# ifndef rmdocinc
c  ATTPHY    phytoplankton light attenuation scale (liter umole-1 cm-1).
c  BIOPOS    switch to enforce positive biological fields:
c            [0] do not enforce, [1] enforce.
#  if defined codunlim | defined codlim
#   if defined codunlim
c  CDKP      prey response coefficient.                 [(cm^2 m^3)/(s mmole N)]
c  CDKT      temperature response coefficient.             {cm^2/[s (deg C)^2]}
c  CDKZ      depth response coefficient.                   (cm/s)
#   else
c  CDKP      prey response coefficient.                 [(cm m^3)/(mmole N)]
c  CDKT      temperature response coefficient.             [cm/(deg C)^2]
c  CDKZ      depth response coefficient.
#   endif
c  CDSPD     maximum cod cruising speed.                   (cm/s)
c  CDTMAX    maximum preferred temperature for cod.        (deg C)
c  CDTMIN    minimum preferred temperature for cod.        (deg C)
c  CDWMAX    maximum vertical swimming speed.              (cm/s)
c  CDZMAX    maximum water depth for cod                   (cm).
c  CDZMIN    minimum water depth for cod                   (cm).
#  endif
c  CIVLEV    Ivlev constant for zooplankton grazing of phytoplankton 
c            (l/umoles).
c  FRACRMN   fraction of the sinking phytoplankton and detritus flux 
c            that reaches the seafloor that is remineralized in the 
c            bottom level; the remainder is "buried" (nondimensional).
c  GRAZRM    maximum phytoplankton grazing rate (1/sec).
c  HSNH4     half saturation constant for ammonium uptake (umoles/l).
c  HSNO3     half saturation constant for nitrate uptake (umoles/l).
c  IBIOUT    output write switches. [0] do not write, [1] write.
c  IDET      index for detritus in tracer array.
c  INH4      index for ammonium in tracer array.
c  INO3      index for nitrate in tracer array.
c  IPHY      index for phytoplankton in tracer array.
c  IZOO      index for zooplankton in tracer array.
c  NH4PR     recycled (NH4) production rate (umoles liter-1 sec-1).
c  NO3INH    strength of ammonium inhibition of nitrate uptake 
c            (l/umoles).
c  NO3PR     new (NO3) production rate (umoles liter-1 sec-1).
c  PARFRAC   fraction of shortwave radiation that is photosynthetically
c            active (nondimensional).
c  PHOTOINH  photoinhibition parameter (cm^2/cal).
c  PHOTOR0   initial slope of photosynthesis response to light 
c            (cm^2/cal).
c  PHOTORM   maximum photosynthetic rate (1/sec).
c  PHYLR1    linear phytoplankton mortality rate (1/sec).
c  PHYLR2    quadratic phytoplankton mortality rate (1/sec l/umoles).
c  REMNDET   detritus remineralization timescale (1/sec).
c  REMNNH4   NH4 remineralization (nitrification) timescale (1/sec).
c  WSNKDET   sinking rate for detritus (positive down)  (cm/sec).
c  WSNKPHY   sinking rate for phytoplankton (positive down)  (cm/sec).
c  ZGRPHY    zooplankton grazing rate (umoles liter-1 sec-1)
c  ZOOEXCD   fraction of zooplankton grazing that is excreted as 
c            detritus (nondimensional).
c  ZOOEXCN   fraction of zooplankton grazing that is excreted as
c            ammonium (nondimensional).
c  ZOOLF1    fraction of linear zooplankton loss to detritus
c            (nondimensional).
c  ZOOLF2    fraction of quadratic zooplankton loss to detritus
c            (nondimensional).
c  ZOOLR1    linear zooplankton loss rate (1/sec).
c  ZOOLR2    quadratic zooplankton loss rate (1/sec l/umoles).
c
c=======================================================================
c
# endif
      common /icbiopnh/ biopos,ibiout
      integer biopos,ibiout(20)
c
      common /fcbiopnh/ attphy,photorm,photor0,photoinh,hsno3,hsnh4,
     *       no3inh,phylr1,phylr2,grazrm,civlev,zooexcn,zooexcd,zoolr1,
     *       zoolr2,zoolf1,zoolf2,wsnkphy,wsnkdet,fracrmn,remnnh4,
     *       remndet,parfrac,
     *       nh4pr,no3pr,zgrphy
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       attphy,photorm,photor0,photoinh,hsno3,hsnh4,
     *       no3inh,phylr1,phylr2,grazrm,civlev,zooexcn,zooexcd,zoolr1,
     *       zoolr2,zoolf1,zoolf2,wsnkphy,wsnkdet,fracrmn,remnnh4,
     *       remndet,parfrac
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       nh4pr(imt,km),no3pr(imt,km),zgrphy(imt,km)
c
      integer idet,inh4,ino3,iphy,izoo
      parameter (ino3=3,iphy=4,izoo=5,inh4=6,idet=7)
# if defined codunlim | defined codlim | defined cod_ing
      integer icod
      parameter (icod=8)
# endif
#endif
#ifdef bioDuse
# ifndef rmdocinc
c  ACHLA     absorption coefficient for chl a (m^2/mg).
c  ACHLB     absorption coefficient for chl b (m^2/mg).
c  ACHLC     absorption coefficient for chl c (m^2/mg).
c  APPC      absorption coefficient for photoprotectant carotenoids
c            (m^2/mg).
c  APSC      absorption coefficient for photosynthetic carotenods
c            (m^2/mg).
c  ATTH2OS   spectral attenuation due to water (Kw) (m-1).
c  ATTPHY    phytoplankton light attenuation scale (liter umole-1 cm-1).
c  BIOPOS    switch to enforce positive biological fields:
c            [0] do not enforce, [1] enforce.
#  if defined codunlim | defined codlim
#   if defined codunlim
c  CDKP      prey response coefficient.                 [(cm^2 m^3)/(s mmole N)]
c  CDKT      temperature response coefficient.             {cm^2/[s (deg C)^2]}
c  CDKZ      depth response coefficient.                   (cm/s)
#   else
c  CDKP      prey response coefficient.                 [(cm m^3)/(mmole N)]
c  CDKT      temperature response coefficient.             [cm/(deg C)^2]
c  CDKZ      depth response coefficient.
#   endif
c  CDSPD     maximum cod cruising speed.                   (cm/s)
c  CDTMAX    maximum preferred temperature for cod.        (deg C)
c  CDTMIN    minimum preferred temperature for cod.        (deg C)
c  CDWMAX    maximum vertical swimming speed.              (cm/s)
c  CDZMAX    maximum water depth for cod                   (cm).
c  CDZMIN    minimum water depth for cod                   (cm).
#  endif
c  CHA2CHB   Chl a to Chl b conversion (b:a ratio) (mg/mg).
c  CHA2CHC   Chl a to Chl c conversion (c:a ratio) (mg/mg).
c  CHA2PPC   Chl a to PP carotenoids (ppc:a ratio) (mg/mg).
c  CHA2PSC   Chl a to PS carotenoids (psc:a ratio) (mg/mg).
c  CHIL      Chi(lambda) from Morel and Antoine model of phyto
c            attenuation (no units, but chl in mg/m^3, K in m-1).
c  CHLCRATE  rate constant of photoacclimation for chl:c (units???)
c  CHL2RAD   factor for converting chl to cell size.
c  CHL2RADE  exponent for chl-size relationship.
c  CIVLEV    Ivlev constant for zooplankton grazing of phytoplankton 
c            (l/ug Chl)
c  C2CHL     Chlorophyl:Carbon ratio (mg Chl/ mg C).
c  C2N       Nitrogen:Carbon ratio (mol N/mol C) of phytoplankton.
c  ELAM      e(lambda) from Morel and Antoine model - see CHIL.
c  FRACRMN   fraction of the sinking phytoplankton and detritus flux 
c            that reaches the seafloor that is remineralized in the 
c            bottom level; the remainder is "buried" (nondimensional).
c  FRACPHY   fraction of the sinking phy flux that remineralizes
c            on the seafloor, i.e. the remainder remains as phy on
c            the seafloor (nondimensional).
c  FRACDET   fraction of the sinking detritus flux that remineralizes
c            on the seafloor, i.e. the remainder remains as detritus on
c            the seafloor (nondimensional).
c  FRNH4NO3  Fraction of total DIN flux from the sediments (benthic flux)
c            that is a NH4+ flux. The NO3- fraction is: 1-frnh4no3.
c  GRAZRM    maximum phytoplankton grazing rate (1/sec).
c  HSNH4     half saturation constant for ammonium uptake (umoles/l).
c  HSNO3     half saturation constant for nitrate uptake (umoles/l).
c  HT2QNTA   conversion factor from watts to quanta/sec. (quanta/sec/
c              watt).
c  IBIOUT    output write switches. [0] do not write, [1] write.
c  ICHL      index for chlorophyll in tracer array.
c  IDET      index for detritus in tracer array.
c  INH4      index for ammonium in tracer array.
c  INO3      index for nitrate in tracer array.
c  IPMBID    index identifying bidigare et al. spectral productivity
c              model.
c  IPMEXP    index identifying exponential form for productivity model
c  IPMOD     productivity model switch.
c  IPMTNH    index identifying hyperbolic tangent form for productivity
c              model
c  IPMKM     index identifying Kiefer and Mitchell (1983) model ("white
c              light" model)
c  IPMSMI    index identifying Smith (1936) productivity model
c  IQN3      index for cellular nitrogen (from nitrate) in tracer array.
c  IQN4      index for cellular nitrogen (from ammonia) in tracer array.
c  IZOO      index for zooplankton in tracer array.
c  LMDAMIN   lower limit of light spectrum for productivity model (nm).
c  LMDAMAX   upper limit of light spectrum for productivity model (nm).
c  NH4PR     recycled (NH4) production rate (umoles liter-1 sec-1).
c  NH4URM    maximum ammonium uptake rate 
c            (umoles N / ug chl 1/day).
c  NO3INH    strength of ammonium inhibition of nitrate uptake 
c            (l/umoles).
c  NO3PR     new (NO3) production rate (umoles liter-1 sec-1).
c  NO3URM    maximum nitrate uptake rate
c            (umoles N / ug chl 1/day).
c  NQUOTA    minimum nitrogen quota (Qo in Droop model)
c            (umoles N / ug chl).
c  PARFRAC   fraction of shortwave radiation that is photosynthetically
c            active (nondimensional).
c  PHIM      Maximum quantum yield C-based (mol C/mol photons)
c  PHOTOINH  photoinhibition parameter
c            ((mgC/mgChl/sec)/(umole photonsm2/sec)).
c  PHOTOR0   initial slope of photosynthesis response to light 
c            ((mgC/mgChl/sec)/(umole photonsm2/sec)).
c  PHOTORM   maximum photosynthetic rate (mgC/mgChl/sec).
c  PHYLR1    linear phytoplankton mortality rate (1/sec).
c  PHYLR2    quadratic phytoplankton mortality rate (1/sec l/umoles).
c  R_ATTH2O  Regional light attenuation scale of sea water (cm-1).
c  REMNDET   detritus remineralization timescale (1/sec).
c  REMNNH4   NH4 remineralization (nitrification) timescale (1/sec).
c  RHOPHY    phytoplankton density (same units as density).
c  VISCH2O   viscosity of seawater (   ).
c  WSJ       weighting factors for irradiance (nondimensional).
c  WSNKDET   sinking rate for detritus (positive down)  (cm/sec).
c  WSNKPHY   sinking rate for phytoplankton (positive down)  (cm/sec).
c  ZGRPHY    zooplankton grazing rate (umoles liter-1 sec-1)
c  ZOOEXCD   fraction of zooplankton grazing that is excreted as 
c            detritus (nondimensional).
c  ZOOEXCN   fraction of zooplankton grazing that is excreted as
c            ammonium (nondimensional).
c  ZOOLF1    fraction of linear zooplankton loss to detritus
c            (nondimensional).
c  ZOOLF2    fraction of quadratic zooplankton loss to detritus
c            (nondimensional).
c  ZOOLR1    linear zooplankton loss rate (1/sec).
c  ZOOLR2    quadratic zooplankton loss rate (1/sec l/umoles).
c
c=======================================================================
c
# endif
      common /icbiopnh/ biopos,ipmod,ibiout
      integer biopos,ipmod,ibiout(20)
c
      common /fcbiopnh/ attphy,photorm,photor0,photoinh,hsno3,hsnh4,
     *       no3inh,phylr1,phylr2,grazrm,civlev,zooexcn,zooexcd,zoolr1,
     *       zoolr2,zoolf1,zoolf2,wsnkphy,wsnkdet,fracrmn,
     *       fracphy,fracdet,frnh4no3,remnnh4,remndet,parfrac,r_atth2o,
     *       nh4pr,no3pr,zgrphy,nquota,nh4urm,no3urm,c2chl,dn2dchl,
     *       chl2c0,chl2c1,ir0_wm2,ir1_wm2,chlcrate,
     *       cha2chb,cha2chc,cha2ppc,cha2psc,c2n,phim,
     *       achla,achlb,achlc,appc,apsc,atth2os,chil,elam,
     *       ht2qnta,wsj,lmdamin,lmdamax,
     *       chlcinf,minchlc,maxchlc
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       attphy,photorm,photor0,photoinh,hsno3,hsnh4,
     *       no3inh,phylr1,phylr2,grazrm,civlev,zooexcn,zooexcd,zoolr1,
     *       zoolr2,zoolf1,zoolf2,wsnkphy,wsnkdet,fracrmn,
     *       fracphy,fracdet,frnh4no3,remnnh4,remndet,parfrac,r_atth2o,
     *       nquota,nh4urm,no3urm,c2chl,dn2dchl,
     *       chl2c0,chl2c1,ir0_wm2,ir1_wm2,chlcrate,
     *       cha2chb,cha2chc,cha2ppc,cha2psc,c2n,phim,
     *       ht2qnta,lmdamin,lmdamax
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       nh4pr(imt,km),no3pr(imt,km),zgrphy(imt,km),
     *       achla(lm),achlb(lm),achlc(lm),appc(lm),apsc(lm),
     *       atth2os(lm),chil(lm),elam(lm),wsj(lm),
     *       chlcinf(imt,km),minchlc,maxchlc
c
      integer idet,inh4,ino3,izoo,iqn3,iqn4,ichl
      parameter (ino3=3,iqn3=4,izoo=5,inh4=6,idet=7,ichl=8,iqn4=9)
# if defined codunlim | defined codlim | defined cod_ing
      integer icod
      parameter (icod=10)
# endif
      integer ipmexp,ipmtnh,ipmkm ,ipmsmi,ipmbid
      parameter (ipmexp=0,ipmtnh=1,ipmkm=2,ipmsmi=3,ipmbid=4)
      FLOAT
     *       chl2rad,chl2rade,rhophy,visch2o
      parameter(rhophy=75.0,visch2o=9.1e-4,chl2rad=5.15*c1em12,
     *          chl2rade=0.753)                    
#endif
#ifdef bioFasham
# ifndef rmdocinc
c  ATTPHY   light attenuation by phytoplankton (liter umole-1 cm-1).
c  BACFRAC  bacterial ratio of NH4/DON uptake (nondimensional).
c  BACGRK   bacteria uptake half-saturation constant (umoles/l).
c  BACGRR   bacteria maximum growth rate (sec-1).
c  BEXCRR   bacteria excretion rate to NH4 (sec-1).
c  BGRDON   bacteria uptake rate of DON (umoles liter-1 sec-1)
c  BGRNH4   bacteria uptake rate of NH4 (umoles liter-1 sec-1)
c  BIOPOS   switch to enforce positive biological fields:
c           [0] do not enforce, [1] enforce.
c  BRKNPON  PON breakdown rate to DON (sec-1).
#  if defined codunlim | defined codlim
#   if defined codunlim
c  CDKP      prey response coefficient.                 [(cm^2 m^3)/(s mmole N)]
c  CDKT      temperature response coefficient.             {cm^2/[s (deg C)^2]}
c  CDKZ      depth response coefficient.                   (cm/s)
#   else
c  CDKP      prey response coefficient.                 [(cm m^3)/(mmole N)]
c  CDKT      temperature response coefficient.             [cm/(deg C)^2]
c  CDKZ      depth response coefficient.
#   endif
c  CDSPD     maximum cod cruising speed.                   (cm/s)
c  CDTMAX    maximum preferred temperature for cod.        (deg C)
c  CDTMIN    minimum preferred temperature for cod.        (deg C)
c  CDWMAX    maximum vertical swimming speed.              (cm/s)
c  CDZMAX    maximum water depth for cod                   (cm).
c  CDZMIN    minimum water depth for cod                   (cm).
#  endif
c  FPFLUX   export particle flux (10^-5 moles m-2 second-1). Note that
c           this is based on the zmortex*zmortr*zoo term, and does not
c           include the PON sinking flux.
c  FPREMN   export remineralization rate in the euphotic zone, based on
c           Martin et al. (1987) carbon flux. (umoles liter-1 second-1)
c  GRTHPA   temperature-dependent growth rate parameter "a" (sec-1).
c  GRTHPB   temperature-dependent growth rate parameter "b" (nondimen).
c  GRTHPC   temperature-dependent growth rate parameter "c" (degC-1).
c  HSNH4    half saturation constant for ammonium uptake (umoles/l).
c  HSNO3    half saturation constant for nitrate uptake (umoles/l).
c  IBAC     index for bacteria in tracer array.
c  IBIOUT   output write switches. [0] do not write, [1] write.
c  IDON     index for dissolved organic nitrogen in tracer array.    
c  INH4     index for ammonium in tracer array.
c  INO3     index for nitrate in tracer array.
c  IPHY     index for phytoplankton in tracer array.
c  IPON     index for particulate organic nitrogen in tracer array.
c  IZOO     index for zooplankton in tracer array.
c  NH4PR    recycled (NH4) production rate (umoles liter-1 sec-1).
c  NO3INH   strength of ammonium inhibition of nitrate uptake (l/umoles)
c  NO3PR    new (NO3) production rate (umoles liter-1 sec-1).
c  PARFRAC  fraction of shortwave radiation that is photosynthetically
c           active (nondimensional).   
c  PHYEXUD  fraction of primary production exuded as DON (nondimen).
c  PHYGRTH  initial slope of P-I curve (degC-1 cm-1).
c  PHYLR1   phytoplankton mortality rate (sec-1).
c  PREFBAC  zooplankton grazing preference for bacteria (nondimen).
c  PREFPHY  zooplankton grazing preference for phytoplankton (nondimen).
c  PREFPON  zooplankton grazing preference for PON (nondimensional).
c  RMNBIO   aphotic zone decay timescale for PHY, ZOO, BAC, DON (sec-1).
c  RMNNH4   aphotic zone decay timescale for NH4 (sec-1).
c  RMNPON1  linear aphotic zone decay timescale for PON (sec-1) .
c  RMNPON2  quadratic decay timescale for PON (liter umole-1 sec-1).
c  SBLDEP   euphotic zone depth (cm).
c  WSNKPON  PON sinking velocity (cm sec-1).
c  ZASSEFF  zooplankton assimilation efficiency fraction (nondimen).
c  ZEXCNH4  fraction of zooplankton excretion to NH4 (nondimensional).
c           (The remainder goes to DON.)
c  ZEXCRR   zooplankton excretion rate (sec-1).
c  ZGRAZR   zooplankton maximum growth rate (sec-1).
c  ZGRAZK   zooplankton growth half-saturation constant (umoles/l).
c  ZGRBAC   zooplankton grazing rate of bacteria 
c           (umoles liter-1 sec-1)
c  ZGRPHY   zooplankton grazing rate of phytoplankton 
c           (umoles liter-1 sec-1)
c  ZGRPON   zooplankton grazing rate of PON (umoles liter-1 sec-1)
c  ZMORTEX  fraction of zooplankton mortality to export (nondimen).
c           (The remainder goes to NH4.)
c  ZMORTR   zooplankton mortality rate (sec-1).
c
c=======================================================================
c
# endif
      common /icbiopnh/ biopos,ibiout
      integer biopos,ibiout(20)
c
      common /fcbiopnh/ attphy,phygrth,phyexud,phylr1,grthpa,grthpb,
     *       grthpc,hsno3,hsnh4,no3inh,zgrazr,zgrazk,zasseff,prefphy,
     *       prefbac,prefpon,zexcrr,zexcnh4,zmortr,zmortex,bacgrr,
     *       bacgrk,bacfrac,bexcrr,wsnkpon,brknpon,rmnbio,rmnpon1,
     *       rmnpon2,rmnnh4,sbldep,parfrac,
     *       nh4pr,no3pr,zgrphy,zgrbac,zgrpon,bgrdon,bgrnh4,
     *       fpflux,fpremn
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       attphy,phygrth,phyexud,phylr1,grthpa,grthpb,
     *       grthpc,hsno3,hsnh4,no3inh,zgrazr,zgrazk,zasseff,prefphy,
     *       prefbac,prefpon,zexcrr,zexcnh4,zmortr,zmortex,bacgrr,
     *       bacgrk,bacfrac,bexcrr,wsnkpon,brknpon,rmnbio,rmnpon1,
     *       rmnpon2,rmnnh4,sbldep,parfrac
# if defined codunlim | defined codlim | defined cod_ing
     *       ,cdkp,cdkt,cdkz,cdspd,cdtmax,cdtmin,cdwmax,cdzmax,cdzmin
# endif
      FLOAT
     *       nh4pr(imt,km),no3pr(imt,km),zgrphy(imt,km),zgrbac(imt,km),
     *       zgrpon(imt,km),bgrdon(imt,km),bgrnh4(imt,km),
     *       fpflux(imt,kmp1),fpremn(imt,km)
c
      integer ino3,iphy,izoo,inh4,ipon,idon,ibac
      parameter (ino3=3,iphy=4,izoo=5,inh4=6,ipon=7,idon=8,ibac=9)
# if defined codunlim | defined codlim | defined cod_ing
      integer icod
      parameter (icod=10)
# endif
#endif
